/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import otsunozi.nikkorihazard.init.InitTileEntity;

public class TileEntityNCSingleSpawner
extends TileEntity
implements ITickableTileEntity {
    private WeightedSpawnerEntity spawnData = new WeightedSpawnerEntity();
    private EntityType<?> spawnEntity;
    private final List<WeightedSpawnerEntity> potentialSpawns = Lists.newArrayList();
    private static final Logger LOGGER = LogManager.getLogger();
    private short spawnRange = (short)10;

    public TileEntityNCSingleSpawner() {
        super(InitTileEntity.NCSINGLESPAWNER);
    }

    public TileEntityNCSingleSpawner(EntityType<?> type, short range) {
        this();
        this.setEntityType(type);
        this.spawnRange = range;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isActivated()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 2);
            this.func_145843_s();
            CompoundNBT compoundnbt = this.spawnData.func_185277_b();
            Optional optional = EntityType.func_220347_a((CompoundNBT)compoundnbt);
            if (!optional.isPresent()) {
                LOGGER.warn("\u30b7\u30f3\u30b0\u30eb\u30b9\u30dd\u30ca\u30fc\u30a8\u30e9\u30fc Entity\u672a\u8a2d\u5b9a");
                return;
            }
            MobEntity mob = (MobEntity)((EntityType)optional.get()).func_200721_a(this.field_145850_b);
            BlockPos blockpos = this.func_174877_v();
            Random rand = new Random();
            mob.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, rand.nextFloat() * 360.0f);
            if (this.field_145850_b.func_217376_c((Entity)mob)) {
                mob.func_213386_a((IServerWorld)((ServerWorld)this.field_145850_b), this.field_145850_b.func_175649_E(mob.func_233580_cy_()), SpawnReason.REINFORCEMENT, (ILivingEntityData)null, (CompoundNBT)null);
                mob.func_70656_aK();
            }
        }
    }

    public boolean canEntityBeSeen(Entity entityIn) {
        double z;
        BlockPos blockpos = this.func_174877_v();
        Vector3d vector3d = new Vector3d((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
        Vector3d vector3d1 = new Vector3d(entityIn.func_226277_ct_(), entityIn.func_226280_cw_(), entityIn.func_226281_cx_());
        double x = vector3d.func_82615_a() < vector3d1.func_82615_a() ? 0.4 : -0.4;
        double y = vector3d.func_82617_b() < vector3d1.func_82617_b() ? 0.4 : -0.4;
        double d = z = vector3d.func_82616_c() < vector3d1.func_82616_c() ? 0.4 : -0.4;
        if (this.field_145850_b.func_180495_p(blockpos.func_177963_a(x * 2.5, y * 2.5, z * 2.5)).func_235785_r_((IBlockReader)this.field_145850_b, blockpos.func_177963_a(x * 2.5, y * 2.5, z * 2.5))) {
            x = 0.0;
            y = 0.0;
            z = 0.0;
        }
        vector3d = vector3d.func_72441_c(x, y, z);
        Vector3d vector3d2 = vector3d.func_178787_e(vector3d1.func_216371_e()).func_216371_e();
        vector3d = vector3d.func_178787_e(vector3d2.func_72432_b());
        if (entityIn.field_70170_p != this.field_145850_b || vector3d1.func_72436_e(vector3d) > 16384.0) {
            return false;
        }
        return this.field_145850_b.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    private boolean isActivated() {
        BlockPos blockpos = this.func_174877_v();
        PlayerEntity player = this.field_145850_b.func_217366_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.spawnRange, false);
        if (player != null && !player.func_184812_l_()) {
            return this.canEntityBeSeen((Entity)player);
        }
        return false;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.potentialSpawns.clear();
        if (nbt.func_150297_b("SpawnPotentials", 9)) {
            ListNBT listnbt = nbt.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.potentialSpawns.add(new WeightedSpawnerEntity(listnbt.func_150305_b(i)));
            }
        }
        if (nbt.func_150297_b("SpawnData", 10)) {
            this.setNextSpawnData(new WeightedSpawnerEntity(1, nbt.func_74775_l("SpawnData")));
        } else if (!this.potentialSpawns.isEmpty()) {
            this.setNextSpawnData((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_145831_w().field_73012_v, this.potentialSpawns));
        }
        this.spawnRange = nbt.func_74765_d("SpawnRange");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ResourceLocation resourcelocation = this.getEntityId();
        if (resourcelocation == null) {
            return compound;
        }
        compound.func_218657_a("SpawnData", (INBT)this.spawnData.func_185277_b().func_74737_b());
        ListNBT listnbt = new ListNBT();
        if (this.potentialSpawns.isEmpty()) {
            listnbt.add((Object)this.spawnData.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedspawnerentity : this.potentialSpawns) {
                listnbt.add((Object)weightedspawnerentity.func_185278_a());
            }
        }
        compound.func_218657_a("SpawnPotentials", (INBT)listnbt);
        compound.func_74777_a("SpawnRange", this.spawnRange);
        return compound;
    }

    public void setNextSpawnData(WeightedSpawnerEntity nextSpawnData) {
        this.spawnData = nextSpawnData;
    }

    public void setEntityType(EntityType<?> type) {
        this.spawnData.func_185277_b().func_74778_a("id", Registry.field_212629_r.func_177774_c(type).toString());
    }

    @Nullable
    private ResourceLocation getEntityId() {
        String s = this.spawnData.func_185277_b().func_74779_i("id");
        try {
            return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            BlockPos blockpos = this.func_174877_v();
            LOGGER.warn("Invalid entity id '{}' at spawner {}:[{},{},{}]", (Object)s, (Object)this.func_145831_w().func_234923_W_().func_240901_a_(), (Object)blockpos.func_177958_n(), (Object)blockpos.func_177956_o(), (Object)blockpos.func_177952_p());
            return null;
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compoundnbt = this.func_189515_b(new CompoundNBT());
        compoundnbt.func_82580_o("SpawnPotentials");
        return compoundnbt;
    }

    public boolean func_183000_F() {
        return true;
    }
}

