/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.WeightedRandom;
import otsunozi.nikkorihazard.enchantment.NCustomEnchantmentHelper;
import otsunozi.nikkorihazard.init.NCustomItem;
import otsunozi.nikkorihazard.item.enchantbook.ItemSpecialEnchantBook;
import otsunozi.nikkorihazard.util.ItemWeightData;

public class NMobDropUtil {
    public static final int MELEE_ENCHANT_BOOK = 0;
    public static final int MAGIC_ENCHANT_BOOK = 1;
    public static final int ANY_ENCHANT_BOOK = 99;

    public static boolean isPlayerAttack(LivingEntity sourceEntity, boolean wasRecentlyHit) {
        return sourceEntity.func_94060_bK() != null && sourceEntity.func_94060_bK() instanceof PlayerEntity;
    }

    public static void dropItem(Entity entity, Item item, int count) {
        for (int j = 0; j < count; ++j) {
            entity.func_199703_a((IItemProvider)item);
        }
    }

    public static void dropBaseItem(Entity entity, DamageSource source, Item item, Random rand, boolean wasRecentlyHit, int lootingModifier) {
        NMobDropUtil.dropBaseItemForCount(entity, source, item, 2, rand, wasRecentlyHit, lootingModifier);
    }

    public static void dropBaseItemForCount(Entity entity, DamageSource source, Item item, int maxDropCount, Random rand, boolean wasRecentlyHit, int lootingModifier) {
        int i = rand.nextInt(maxDropCount + 1);
        if (lootingModifier > 0) {
            i += rand.nextInt(lootingModifier + 1);
        }
        for (int j = 0; j < i; ++j) {
            entity.func_199703_a((IItemProvider)item);
        }
    }

    public static void dropBaseRandomItems(LivingEntity entity, DamageSource source, Item[] itemDrops, int loopCount, Random rand, boolean wasRecentlyHit, int lootingModifier) {
        int i = loopCount;
        if (NMobDropUtil.isPlayerAttack(entity, wasRecentlyHit)) {
            for (int j = 0; j < i; ++j) {
                int k = rand.nextInt(3) + 1;
                Item item = itemDrops[rand.nextInt(itemDrops.length)];
                if (lootingModifier > 0) {
                    k += rand.nextInt(lootingModifier + 1);
                }
                for (int l = 0; l < k; ++l) {
                    entity.func_199703_a((IItemProvider)item);
                }
            }
        }
    }

    public static void dropRareItem(LivingEntity entity, DamageSource source, float rate, Item item, int count, boolean wasRecentlyHit) {
        Random rand = new Random();
        int trueRate = (int)(rate * 10.0f);
        if (NMobDropUtil.isPlayerAttack(entity, wasRecentlyHit) && rand.nextInt(1000) < trueRate) {
            int i = count;
            for (int j = 0; j < i; ++j) {
                entity.func_199703_a((IItemProvider)item);
            }
        }
    }

    public static void dropNikkorinium(LivingEntity entity, DamageSource source, int rate, boolean wasRecentlyHit, int lootingModifier) {
        NMobDropUtil.dropNikkoriniumBoost(entity, source, rate, 2, wasRecentlyHit, lootingModifier);
    }

    public static void dropNikkoriniumBoost(LivingEntity entity, DamageSource source, int rate, int maxDropCount, boolean wasRecentlyHit, int lootingModifier) {
        Random rand = new Random();
        int boostrate = 10 * lootingModifier;
        if (NMobDropUtil.isPlayerAttack(entity, wasRecentlyHit) && rand.nextInt(100) < rate + boostrate) {
            int i = rand.nextInt(maxDropCount) + 1;
            for (int j = 0; j < i; ++j) {
                entity.func_199703_a((IItemProvider)NCustomItem.NIKKORINIUM);
            }
        }
    }

    public static boolean dropEnchantBook(LivingEntity entity, DamageSource source, float rate, int spBooklevel, boolean wasRecentlyHit, int bookType, DropBookKindSets bookKindSet) {
        Random rand = new Random();
        ItemStack book = new ItemStack((IItemProvider)Items.field_151055_y);
        int trueRate = (int)(rate * 10.0f);
        if (NMobDropUtil.isPlayerAttack(entity, wasRecentlyHit) && entity.func_94060_bK() != null && rand.nextInt(1000) < trueRate) {
            if (bookType == 0) {
                book = NMobDropUtil.getMeleeWeaponBookList(rand, bookKindSet);
            } else if (bookType == 1) {
                book = NMobDropUtil.getMagicWeaponBookList(rand, bookKindSet);
            } else if (bookType == 99) {
                book = rand.nextInt(100) < 50 ? NMobDropUtil.getMeleeWeaponBookList(rand, bookKindSet) : NMobDropUtil.getMagicWeaponBookList(rand, bookKindSet);
            }
            if (book.func_77973_b() instanceof ItemSpecialEnchantBook) {
                book = NCustomEnchantmentHelper.addEnchantmentWithSPbook(rand, book, spBooklevel);
            }
            entity.func_199701_a_(book);
            return true;
        }
        return false;
    }

    private static ItemStack getMeleeWeaponBookList(Random rand, DropBookKindSets bookKindSet) {
        ArrayList bookList = Lists.newArrayList();
        bookList.add(new ItemWeightData(NCustomItem.N_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_NORMAL_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.H_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_HARD_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.VH_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_VERYHARD_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.SP_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_SPECIAL_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.C_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_CRAZY_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.W_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_WICKED_NORMAL_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.WH_WEAPON_ENCHANTBOOK, bookKindSet.getRATE_WICKED_HARD_BOOK()));
        return new ItemStack((IItemProvider)((ItemWeightData)WeightedRandom.func_76271_a((Random)rand, (List)bookList)).getItem());
    }

    private static ItemStack getMagicWeaponBookList(Random rand, DropBookKindSets bookKindSet) {
        ArrayList bookList = Lists.newArrayList();
        bookList.add(new ItemWeightData(NCustomItem.N_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_NORMAL_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.H_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_HARD_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.VH_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_VERYHARD_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.SP_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_SPECIAL_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.C_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_CRAZY_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.W_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_WICKED_NORMAL_BOOK()));
        bookList.add(new ItemWeightData(NCustomItem.WH_MAGIC_ENCHANTBOOK, bookKindSet.getRATE_WICKED_HARD_BOOK()));
        return new ItemStack((IItemProvider)((ItemWeightData)WeightedRandom.func_76271_a((Random)rand, (List)bookList)).getItem());
    }

    public static boolean dropCriticalMedal(LivingEntity entity, DamageSource source, float rate, boolean wasRecentlyHit, DropMedalKindSets medalKindSet) {
        ItemStack medal = new ItemStack((IItemProvider)Items.field_151055_y);
        Random rand = new Random();
        int trueRate = (int)(rate * 10.0f);
        if (NMobDropUtil.isPlayerAttack(entity, wasRecentlyHit) && rand.nextInt(1000) < trueRate) {
            medal = NMobDropUtil.getMedalForList(rand, medalKindSet);
            entity.func_199701_a_(medal);
            return true;
        }
        return false;
    }

    private static ItemStack getMedalForList(Random rand, DropMedalKindSets medalKindSet) {
        ArrayList bookList = Lists.newArrayList();
        bookList.add(new ItemWeightData(NCustomItem.MEDAL_OF_EVIL, medalKindSet.getLV_1_MEDAL()));
        bookList.add(new ItemWeightData(NCustomItem.MEDAL_OF_NIGHTMARE, medalKindSet.getLV_2_MEDAL()));
        bookList.add(new ItemWeightData(NCustomItem.MEDAL_OF_WICKED, medalKindSet.getLV_3_MEDAL()));
        bookList.add(new ItemWeightData(NCustomItem.MEDAL_OF_DESTROY, medalKindSet.getLV_4_MEDAL()));
        return new ItemStack((IItemProvider)((ItemWeightData)WeightedRandom.func_76271_a((Random)rand, (List)bookList)).getItem());
    }

    public static enum DropMedalKindSets {
        WEAK_MOB(90, 10, 0, 0),
        NORMAL_MOB(50, 40, 10, 0),
        STRONG_MOB(30, 40, 10, 0),
        RARE_MOB(30, 35, 30, 5);

        private final int LV_1_MEDAL;
        private final int LV_2_MEDAL;
        private final int LV_3_MEDAL;
        private final int LV_4_MEDAL;

        private DropMedalKindSets(int evil_medal_rate, int nightmare_medal_rate, int wicked_medal_rate, int destroy_medal_rate) {
            this.LV_1_MEDAL = evil_medal_rate;
            this.LV_2_MEDAL = nightmare_medal_rate;
            this.LV_3_MEDAL = wicked_medal_rate;
            this.LV_4_MEDAL = destroy_medal_rate;
        }

        public int getLV_1_MEDAL() {
            return this.LV_1_MEDAL;
        }

        public int getLV_2_MEDAL() {
            return this.LV_2_MEDAL;
        }

        public int getLV_3_MEDAL() {
            return this.LV_3_MEDAL;
        }

        public int getLV_4_MEDAL() {
            return this.LV_4_MEDAL;
        }
    }

    public static enum DropBookKindSets {
        NORMAL_AND_SPECIAL_1(85, 10, 0, 5, 0, 0, 0),
        NORMAL_AND_SPECIAL_2(60, 25, 0, 15, 0, 0, 0),
        NORMAL_AND_SPECIAL_3(55, 25, 5, 15, 0, 0, 0),
        NORMAL_AND_SPECIAL_4(30, 35, 20, 15, 0, 0, 0),
        RARE_MOB(30, 50, 10, 10, 0, 0, 0),
        CRAZY_NIKKORI(30, 25, 15, 30, 0, 0, 0),
        GOLDEN_SMILE(0, 0, 0, 70, 5, 15, 10),
        DIAMOND_SMILE(5, 25, 35, 25, 10, 0, 0),
        WATER_CHEST_LEGEND(0, 0, 0, 100, 0, 0, 0),
        WICKED_WEAK(0, 0, 0, 80, 0, 20, 0),
        WICKED_NORMAL(0, 0, 0, 80, 0, 10, 10),
        WICKED_HARD(0, 0, 0, 70, 0, 10, 20),
        RED_BEETLE(40, 5, 5, 50, 0, 0, 0),
        NETHER_MONSTER(50, 20, 5, 25, 0, 0, 0),
        OTSUROCK(30, 10, 20, 40, 0, 0, 0),
        NIKKORIBOA_LEVEL_3(31, 27, 5, 37, 0, 0, 0),
        NIKKORIBOA_LEVEL_4(23, 20, 7, 50, 0, 0, 0),
        NIKKORIBOA_LEVEL_5(16, 13, 9, 62, 0, 0, 0);

        private final int RATE_NORMAL_BOOK;
        private final int RATE_HARD_BOOK;
        private final int RATE_VERYHARD_BOOK;
        private final int RATE_SPECIAL_BOOK;
        private final int RATE_CRAZY_BOOK;
        private final int RATE_WICKED_NORMAL_BOOK;
        private final int RATE_WICKED_HARD_BOOK;

        private DropBookKindSets(int normal_book_rate, int hard_book_rate, int veryhard_book_rate, int special_book_rate, int crazy_book_rate, int wicked_book_rate, int wicked_hard_book_rate) {
            this.RATE_NORMAL_BOOK = normal_book_rate;
            this.RATE_HARD_BOOK = hard_book_rate;
            this.RATE_VERYHARD_BOOK = veryhard_book_rate;
            this.RATE_SPECIAL_BOOK = special_book_rate;
            this.RATE_CRAZY_BOOK = crazy_book_rate;
            this.RATE_WICKED_NORMAL_BOOK = wicked_book_rate;
            this.RATE_WICKED_HARD_BOOK = wicked_hard_book_rate;
        }

        public int getRATE_NORMAL_BOOK() {
            return this.RATE_NORMAL_BOOK;
        }

        public int getRATE_HARD_BOOK() {
            return this.RATE_HARD_BOOK;
        }

        public int getRATE_VERYHARD_BOOK() {
            return this.RATE_VERYHARD_BOOK;
        }

        public int getRATE_SPECIAL_BOOK() {
            return this.RATE_SPECIAL_BOOK;
        }

        public int getRATE_CRAZY_BOOK() {
            return this.RATE_CRAZY_BOOK;
        }

        public int getRATE_WICKED_NORMAL_BOOK() {
            return this.RATE_WICKED_NORMAL_BOOK;
        }

        public int getRATE_WICKED_HARD_BOOK() {
            return this.RATE_WICKED_HARD_BOOK;
        }
    }
}

