/*
 * Decompiled with CFR 0.152.
 */
package otsunozi.nikkorihazard.world.feature.structure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import otsunozi.nikkorihazard.world.feature.piece.WaspBarPiece;

public class StructureWaspBar
extends Structure<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation STRUCTURE = new ResourceLocation("nikkorihazard", "wasp_bar/main");

    public StructureWaspBar() {
        super(NoFeatureConfig.field_236558_a_);
    }

    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        p_230363_5_.func_202425_c(p_230363_3_, p_230363_6_, p_230363_7_);
        double d0 = 0.3f;
        return true;
    }

    private static int findSuitableY(Random rand, ChunkGenerator generator, int p_236339_4_, int p_236339_5_, MutableBoundingBox p_236339_6_) {
        int k;
        int i1 = p_236339_4_ - p_236339_5_;
        int i = StructureWaspBar.getRandomWithinInterval(rand, 30, i1);
        ImmutableList list1 = ImmutableList.of((Object)new BlockPos(p_236339_6_.field_78897_a, 0, p_236339_6_.field_78896_c), (Object)new BlockPos(p_236339_6_.field_78893_d, 0, p_236339_6_.field_78896_c), (Object)new BlockPos(p_236339_6_.field_78897_a, 0, p_236339_6_.field_78892_f), (Object)new BlockPos(p_236339_6_.field_78893_d, 0, p_236339_6_.field_78892_f));
        List list = list1.stream().map(p_236333_1_ -> generator.func_230348_a_(p_236333_1_.func_177958_n(), p_236333_1_.func_177952_p())).collect(Collectors.toList());
        Heightmap.Type heightmap$type = Heightmap.Type.WORLD_SURFACE_WG;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (k = i; k > 15; --k) {
            int l = 0;
            blockpos$mutable.func_181079_c(0, k, 0);
            for (IBlockReader iblockreader : list) {
                BlockState blockstate = iblockreader.func_180495_p((BlockPos)blockpos$mutable);
                if (blockstate == null || !heightmap$type.func_222684_d().test(blockstate) || ++l != 3) continue;
                return k;
            }
        }
        return k;
    }

    private static int randomIntInclusive(Random p_236335_0_, int p_236335_1_, int p_236335_2_) {
        return p_236335_0_.nextInt(p_236335_2_ - p_236335_1_ + 1) + p_236335_1_;
    }

    private static int getRandomWithinInterval(Random p_236338_0_, int p_236338_1_, int p_236338_2_) {
        return p_236338_1_ < p_236338_2_ ? StructureWaspBar.randomIntInclusive(p_236338_0_, p_236338_1_, p_236338_2_) : p_236338_2_;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> p_i225806_1_, int p_i225806_2_, int p_i225806_3_, MutableBoundingBox p_i225806_4_, int p_i225806_5_, long p_i225806_6_) {
            super(p_i225806_1_, p_i225806_2_, p_i225806_3_, p_i225806_4_, p_i225806_5_, p_i225806_6_);
        }

        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator p_230364_2_, TemplateManager p_230364_3_, int p_230364_4_, int p_230364_5_, Biome p_230364_6_, NoFeatureConfig p_230364_7_) {
            Template template = p_230364_3_.func_200220_a(STRUCTURE);
            Rotation rotation = (Rotation)Util.func_240989_a_((Object[])Rotation.values(), (Random)this.field_214631_d);
            Mirror mirror = this.field_214631_d.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
            BlockPos blockpos = new BlockPos(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2);
            BlockPos blockpos1 = new ChunkPos(p_230364_4_, p_230364_5_).func_206849_h();
            MutableBoundingBox mutableboundingbox = template.func_237150_a_(blockpos1, rotation, blockpos, mirror);
            Vector3i vector3i = mutableboundingbox.func_215126_f();
            int i = vector3i.func_177958_n();
            int j = vector3i.func_177952_p();
            int k = p_230364_2_.func_222529_a(i, j, Heightmap.Type.WORLD_SURFACE_WG) - 1;
            int l = StructureWaspBar.findSuitableY((Random)this.field_214631_d, p_230364_2_, k, mutableboundingbox.func_78882_c(), mutableboundingbox);
            BlockPos blockpos2 = new BlockPos(blockpos1.func_177958_n(), l, blockpos1.func_177952_p());
            this.field_75075_a.add(new WaspBarPiece(blockpos2, STRUCTURE, template, rotation, mirror, blockpos));
            this.func_202500_a();
        }
    }
}

