/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes;

import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.trashelemental.potion_slimes.block.ModBlocks;
import net.trashelemental.potion_slimes.entity.ModEntities;
import net.trashelemental.potion_slimes.entity.client.renderers.PotionSlimeRenderer;
import net.trashelemental.potion_slimes.item.ModCreativeModeTabs;
import net.trashelemental.potion_slimes.item.ModItems;
import net.trashelemental.potion_slimes.magic.brewing.ModPotions;
import net.trashelemental.potion_slimes.magic.effects.ModMobEffects;
import net.trashelemental.potion_slimes.magic.enchantments.ModEnchantments;
import org.slf4j.Logger;

@Mod(value="potion_slimes")
public class PotionSlimes {
    public static final String MOD_ID = "potion_slimes";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public PotionSlimes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        ModPotions.register(modEventBus);
        ModMobEffects.register(modEventBus);
        ModEnchantments.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void queueServerWork(int tickDelay, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tickDelay));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actionsToRun = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() <= 0) {
                    actionsToRun.add(work);
                }
            });
            actionsToRun.forEach(work -> ((Runnable)work.getKey()).run());
            workQueue.removeAll(actionsToRun);
        }
    }

    @Mod.EventBusSubscriber(modid="potion_slimes", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SLIME_POTION.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SLIME_POTION_LARGE.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.POTION_SLIME.get()), PotionSlimeRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.POTION_SLIME_SMALL.get()), PotionSlimeRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.POTION_SLIME_LARGE.get()), PotionSlimeRenderer::new);
        }
    }
}

