/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes.compat.JEI;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.trashelemental.potion_slimes.item.ModItems;

public class LargeSlimePotionJEIRecipe
implements IJeiBrewingRecipe {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack ingredient;
    private final ItemStack output;

    public LargeSlimePotionJEIRecipe(ResourceLocation id, Potion potion) {
        this.id = id;
        this.input = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)ModItems.SLIME_POTION.get()), (Potion)potion);
        this.ingredient = new ItemStack((ItemLike)Items.f_42204_);
        this.output = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)ModItems.SLIME_POTION_LARGE.get()), (Potion)potion);
    }

    public List<ItemStack> getPotionInputs() {
        return List.of(this.input);
    }

    public List<ItemStack> getIngredients() {
        return List.of(this.ingredient);
    }

    public ItemStack getPotionOutput() {
        return this.output;
    }

    public int getBrewingSteps() {
        return 1;
    }

    @Nullable
    public ResourceLocation getUid() {
        return this.id;
    }

    public static List<IJeiBrewingRecipe> createAll() {
        return BuiltInRegistries.f_256980_.m_123024_().filter(LargeSlimePotionJEIRecipe::isValidPotion).map(potion -> new LargeSlimePotionJEIRecipe(new ResourceLocation("potion_slimes", "slime_potion/" + BuiltInRegistries.f_256980_.m_7981_(potion).m_135815_()), (Potion)potion)).collect(Collectors.toList());
    }

    private static boolean isValidPotion(Potion potion) {
        if (potion == Potions.f_43598_ || potion == Potions.f_43599_ || potion == Potions.f_43601_ || potion == Potions.f_43600_) {
            return false;
        }
        ResourceLocation id = BuiltInRegistries.f_256980_.m_7981_((Object)potion);
        String path = id.m_135815_();
        return !path.contains("splash") && !path.contains("lingering");
    }
}

