/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes.entity.ai;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.trashelemental.potion_slimes.entity.custom.PotionSlimeEntity;

public class PotionSlimeMoveControl
extends MoveControl {
    private final PotionSlimeEntity slime;
    private float targetYaw;
    private int jumpDelay;

    public PotionSlimeMoveControl(PotionSlimeEntity slime) {
        super((Mob)slime);
        this.slime = slime;
        this.targetYaw = 180.0f * slime.m_146908_() / (float)Math.PI;
    }

    public void setWantedMovement(double speed) {
        this.f_24978_ = speed;
        this.f_24981_ = MoveControl.Operation.MOVE_TO;
    }

    public void m_8126_() {
        LivingEntity owner;
        LivingEntity target = this.slime.m_5448_();
        LivingEntity livingEntity = owner = this.slime.m_21824_() ? this.slime.m_269323_() : null;
        if (target != null) {
            dx = target.m_20185_() - this.slime.m_20185_();
            double dz = target.m_20189_() - this.slime.m_20189_();
            this.targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        } else if (owner != null && this.slime.m_20270_((Entity)owner) > 4.0f) {
            dx = owner.m_20185_() - this.slime.m_20185_();
            double dz = owner.m_20189_() - this.slime.m_20189_();
            this.targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        }
        this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.targetYaw, 90.0f));
        this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
            this.f_24974_.m_21564_(0.0f);
        } else {
            this.f_24981_ = MoveControl.Operation.WAIT;
            if (this.f_24974_.m_20096_()) {
                double moveSpeed = this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_);
                this.f_24974_.m_7910_((float)(moveSpeed *= 1.8));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.slime.getJumpDelay();
                    if (this.f_24974_.m_5912_()) {
                        this.jumpDelay /= 3;
                    }
                    this.slime.m_21569_().m_24901_();
                    this.slime.m_5496_(SoundEvents.f_12387_, 0.8f, 1.0f);
                } else {
                    this.slime.f_20900_ = 0.0f;
                    this.slime.f_20902_ = 0.0f;
                    this.f_24974_.m_7910_(0.0f);
                }
            } else {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_) * 1.8));
            }
        }
    }
}

