/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes.entity.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.trashelemental.potion_slimes.entity.ModEventBusClientEvents;
import net.trashelemental.potion_slimes.entity.client.models.PotionSlimeModel;
import net.trashelemental.potion_slimes.entity.client.renderers.PotionSlimeInnerLayer;
import net.trashelemental.potion_slimes.entity.client.renderers.PotionSlimeOuterLayer;
import net.trashelemental.potion_slimes.entity.custom.LargePotionSlimeEntity;
import net.trashelemental.potion_slimes.entity.custom.PotionSlimeEntity;
import net.trashelemental.potion_slimes.entity.custom.SmallPotionSlimeEntity;

@OnlyIn(value=Dist.CLIENT)
public class PotionSlimeRenderer
extends MobRenderer<PotionSlimeEntity, PotionSlimeModel<PotionSlimeEntity>> {
    private static final ResourceLocation SLIME_LOCATION = new ResourceLocation("potion_slimes", "textures/entity/potion_slime.png");

    public PotionSlimeRenderer(EntityRendererProvider.Context context) {
        super(context, new PotionSlimeModel(context.m_174023_(ModEventBusClientEvents.POTION_SLIME_INNER)), 0.25f);
        this.m_115326_(new PotionSlimeInnerLayer(this, context.m_174027_()));
        this.m_115326_(new PotionSlimeOuterLayer(this, context.m_174027_()));
    }

    public void render(PotionSlimeEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    protected void scale(PotionSlimeEntity slime, PoseStack poseStack, float partialTicks) {
        float size = 2.0f;
        if (slime instanceof SmallPotionSlimeEntity) {
            size = 1.0f;
        } else if (slime instanceof LargePotionSlimeEntity) {
            size = 4.0f;
        }
        float squish = Mth.m_14179_((float)partialTicks, (float)slime.oSquish, (float)slime.squish);
        float stretch = 1.0f / (squish + 1.0f);
        poseStack.m_85841_(stretch * size, 1.0f / stretch * size, stretch * size);
    }

    public ResourceLocation getTextureLocation(PotionSlimeEntity pEntity) {
        return SLIME_LOCATION;
    }
}

