/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes.entity.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.trashelemental.potion_slimes.entity.ModEntities;
import net.trashelemental.potion_slimes.entity.custom.LargePotionSlimeEntity;
import net.trashelemental.potion_slimes.item.ModItems;
import net.trashelemental.potion_slimes.junkyard_lib.entity.method.SummonMethods;

public class LargeSlimePotionProjectileEntity
extends ThrowableItemProjectile {
    private Potion potion = Potions.f_43598_;

    public LargeSlimePotionProjectileEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public LargeSlimePotionProjectileEntity(Level pLevel) {
        super((EntityType)ModEntities.SLIME_POTION_LARGE.get(), pLevel);
    }

    public LargeSlimePotionProjectileEntity(Level level, LivingEntity shooter) {
        super((EntityType)ModEntities.SLIME_POTION_LARGE.get(), shooter, level);
    }

    protected Item m_7881_() {
        return (Item)ModItems.SLIME_POTION_LARGE.get();
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public int getPotionDuration() {
        if (this.potion == null || this.potion == Potions.f_43598_) {
            return 500;
        }
        if (this.potion.m_43491_()) {
            return 500;
        }
        List effects = this.potion.m_43488_();
        if (effects.isEmpty()) {
            return 1800;
        }
        MobEffectInstance effect = (MobEffectInstance)effects.get(0);
        return effect.m_19557_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Potion", 8)) {
            this.potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(new ResourceLocation(tag.m_128461_("Potion")));
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity target = result.m_82443_();
            BlockPos pos = this.m_20183_();
            this.spawnMinions(this.m_9236_(), pos, target);
            this.spawnVFX(pos);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_) {
            BlockPos hitPos = result.m_82425_();
            Direction face = result.m_82434_();
            BlockState hitState = this.m_9236_().m_8055_(hitPos);
            BlockPos spawnPos = hitState.m_60812_((BlockGetter)this.m_9236_(), hitPos).m_83281_() ? hitPos : hitPos.m_121945_(face);
            if (!this.m_9236_().m_8055_(spawnPos).m_60795_()) {
                spawnPos = spawnPos.m_121945_(face);
            }
            if (this.m_9236_().m_8055_(spawnPos).m_60795_() || this.m_9236_().m_6425_(spawnPos).m_76178_()) {
                this.spawnMinions(this.m_9236_(), spawnPos.m_7495_(), null);
                this.spawnVFX(spawnPos);
            } else {
                this.m_9236_().m_5594_(null, spawnPos, SoundEvents.f_12388_, SoundSource.PLAYERS, 0.4f, 0.8f);
            }
            this.m_146870_();
        }
    }

    private void spawnMinions(Level level, BlockPos pos, @Nullable Entity target) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = this.m_19749_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LargePotionSlimeEntity entity2 = (LargePotionSlimeEntity)((EntityType)ModEntities.POTION_SLIME_LARGE.get()).m_20615_((Level)serverLevel);
        if (entity2 == null) {
            return;
        }
        entity2.setPotion(this.getPotion());
        SummonMethods.summonMinion(level, pos, entity2, this.getPotionDuration() + 60, false, (LivingEntity)player);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (this.shouldTarget(target)) {
                entity2.m_6710_(livingTarget);
            }
        }
    }

    private boolean shouldTarget(Entity target) {
        TamableAnimal tamable;
        Entity owner = this.m_19749_();
        if (target == null) {
            return false;
        }
        if (owner == null) {
            return true;
        }
        if (!(owner instanceof Player)) {
            return true;
        }
        Player player = (Player)owner;
        if (target == owner) {
            return false;
        }
        if (target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_21830_((LivingEntity)player)) {
            return false;
        }
        return !target.m_7307_(owner);
    }

    private void spawnVFX(BlockPos pos) {
        this.m_9236_().m_142346_((Entity)this, GameEvent.f_157810_, pos);
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_12436_, SoundSource.PLAYERS, 0.3f, 0.8f);
    }
}

