/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes.entity.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.trashelemental.potion_slimes.PotionSlimes;
import net.trashelemental.potion_slimes.entity.ModEntities;
import net.trashelemental.potion_slimes.entity.ai.PotionSlimeKeepJumpingGoal;
import net.trashelemental.potion_slimes.entity.ai.PotionSlimeMoveControl;
import net.trashelemental.potion_slimes.entity.custom.SmallPotionSlimeEntity;
import net.trashelemental.potion_slimes.junkyard_lib.entity.MinionEntity;
import net.trashelemental.potion_slimes.junkyard_lib.entity.method.SummonMethods;
import net.trashelemental.potion_slimes.junkyard_lib.visual.particle.ParticleMethods;

public class PotionSlimeEntity
extends MinionEntity {
    private static final EntityDataAccessor<String> DATA_POTION = SynchedEntityData.m_135353_(PotionSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected Potion potion = Potions.f_43598_;
    public float squish;
    public float oSquish;
    private float targetSquish;
    private boolean wasOnGround;
    private boolean hasAppliedSelfEffects = false;

    public PotionSlimeEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level, (ParticleOptions)ParticleTypes.f_123753_, (ParticleOptions)ParticleTypes.f_123753_, SoundEvents.f_12389_);
        this.f_21342_ = new PotionSlimeMoveControl(this);
        this.f_21344_ = new GroundPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false, false){

            public boolean m_8036_() {
                return super.m_8036_() && !PotionSlimeEntity.this.m_21824_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(8, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 20.0f, 2.0f, false));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(12, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(13, (Goal)new PotionSlimeKeepJumpingGoal(this));
    }

    public int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    protected void m_6135_() {
        Vec3 motion = this.m_20184_();
        if (this.m_21023_(MobEffects.f_19603_)) {
            this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + (double)0.8f, this.m_20184_().f_82481_);
        } else {
            this.m_20334_(motion.f_82479_, 0.42, motion.f_82481_);
        }
        this.f_19812_ = true;
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation nav = new GroundPathNavigation((Mob)this, level);
        nav.m_7008_(true);
        nav.m_26477_(false);
        nav.m_148214_(false);
        return nav;
    }

    @Override
    public SoundEvent m_7515_() {
        return null;
    }

    @Override
    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_12386_;
    }

    @Override
    public SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_POTION, (Object)"minecraft:empty");
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (DATA_POTION.equals(key)) {
            ResourceLocation id = new ResourceLocation((String)this.f_19804_.m_135370_(DATA_POTION));
            this.potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(id);
        }
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_POTION, (Object)BuiltInRegistries.f_256980_.m_7981_((Object)potion).toString());
        }
    }

    public int getPotionColor() {
        if (this.potion.m_43488_().isEmpty() || this.potion == Potions.f_43599_ || this.potion == Potions.f_43602_ || this.potion == Potions.f_43600_ || this.potion == Potions.f_43601_) {
            return 8110940;
        }
        return PotionUtils.m_43559_((Potion)this.potion);
    }

    public boolean isBeneficial(MobEffect effect) {
        return effect.m_19486_();
    }

    public boolean isHealOrHarm(MobEffect effect) {
        return effect.equals(MobEffects.f_19601_) || effect.equals(MobEffects.f_19602_);
    }

    protected int baseMaxHealth() {
        return 6;
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.potion != null && this.potion != Potions.f_43598_) {
            for (MobEffectInstance instance : this.potion.m_43488_()) {
                MobEffect effect = instance.m_19544_();
                int amplifier = instance.m_19564_() + 1;
                if (effect == MobEffects.f_19601_) {
                    int newMaxHealth = this.baseMaxHealth() + 4 * amplifier;
                    this.m_21051_(Attributes.f_22276_).m_22100_((double)newMaxHealth);
                    PotionSlimes.queueServerWork(4, () -> this.m_21153_(newMaxHealth));
                    continue;
                }
                if (effect != MobEffects.f_19602_) continue;
                this.m_21051_(Attributes.f_22281_).m_22100_((double)(2 + 2 * amplifier));
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.oSquish = this.squish;
        if (this.m_20096_() && !this.wasOnGround) {
            PotionSlimes.queueServerWork(4, () -> {
                this.targetSquish = -0.3f;
            });
        }
        if (!this.m_20096_() && this.wasOnGround) {
            this.targetSquish = 0.4f;
        }
        this.wasOnGround = this.m_20096_();
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.targetSquish *= 0.6f;
        if (this.m_9236_().f_46443_ || this.hasAppliedSelfEffects) {
            return;
        }
        if (this.potion != null && this.potion != Potions.f_43598_) {
            for (MobEffectInstance instance : this.potion.m_43488_()) {
                MobEffect effect = instance.m_19544_();
                if (this.potion == Potions.f_43618_) {
                    this.applySelfEffect(effect, instance.m_19564_());
                    continue;
                }
                if (!this.isBeneficial(effect) || this.isHealOrHarm(effect)) continue;
                this.applySelfEffect(effect, instance.m_19564_());
            }
        }
        this.hasAppliedSelfEffects = true;
    }

    private void applySelfEffect(MobEffect effect, int amplifier) {
        MobEffectInstance current = this.m_21124_(effect);
        if (current == null || current.m_19564_() < amplifier) {
            boolean showParticles = effect == MobEffects.f_19609_;
            this.m_7292_(new MobEffectInstance(effect, -1, amplifier, false, showParticles, true));
        }
    }

    public boolean m_7327_(Entity target) {
        boolean flag = super.m_7327_(target);
        if (!this.m_9236_().f_46443_ && this.potion != null && this.potion != Potions.f_43598_ && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            for (MobEffectInstance instance : this.potion.m_43488_()) {
                MobEffect effect = instance.m_19544_();
                if (this.isBeneficial(effect) || this.potion == Potions.f_43618_ || this.isHealOrHarm(effect)) continue;
                livingTarget.m_7292_(new MobEffectInstance(effect, instance.m_19557_(), instance.m_19564_()));
            }
        }
        return flag;
    }

    public int getReinforcementsNumber() {
        return 4;
    }

    public void m_6667_(DamageSource pCause) {
        LivingEntity owner = this.m_269323_();
        PotionSlimes.queueServerWork(20, () -> this.spawnReinforcements(this.getReinforcementsNumber(), owner));
        super.m_6667_(pCause);
    }

    public void spawnReinforcements(int number, LivingEntity owner) {
        ParticleMethods.ParticlesBurst(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123753_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 10, 0.3);
        for (int i = 0; i < number; ++i) {
            SmallPotionSlimeEntity slime = new SmallPotionSlimeEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.POTION_SLIME_SMALL.get()), this.m_9236_());
            slime.setPotion(this.potion);
            if (this.m_5448_() != null) {
                slime.m_6710_(this.m_5448_());
            }
            double xMotion = this.f_19796_.m_188500_() * 0.1;
            double yMotion = this.f_19796_.m_188500_() * 0.1;
            double zMotion = this.f_19796_.m_188500_() * 0.1;
            slime.m_20334_(xMotion, yMotion, zMotion);
            SummonMethods.summonMinion(this.m_9236_(), this.m_20097_(), slime, this.lifespan, false, owner);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        tag.m_128405_("Lifespan", this.lifespan);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Potion", 8)) {
            ResourceLocation id = new ResourceLocation(tag.m_128461_("Potion"));
            Potion loadedPotion = (Potion)BuiltInRegistries.f_256980_.m_7745_(id);
            this.setPotion(loadedPotion);
        }
        if (tag.m_128425_("Lifespan", 3)) {
            this.setLifespan(tag.m_128451_("Lifespan"), false);
        }
    }
}

