/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.potion_slimes.item.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.trashelemental.potion_slimes.entity.ModEntities;
import net.trashelemental.potion_slimes.entity.custom.PotionSlimeEntity;
import net.trashelemental.potion_slimes.entity.custom.SlimePotionProjectileEntity;
import net.trashelemental.potion_slimes.item.ModItems;
import net.trashelemental.potion_slimes.junkyard_lib.entity.method.SummonMethods;

public class SlimePotionItem
extends Item {
    public SlimePotionItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
    }

    private List<MobEffectInstance> getCustomEffects(ItemStack stack) {
        return PotionUtils.m_43571_((ItemStack)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : PotionUtils.m_43547_((ItemStack)stack)) {
            effects.add(new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
        PotionUtils.m_257410_(effects, tooltip, (float)1.0f);
    }

    public Component m_7626_(ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion == Potions.f_43598_) {
            return Component.m_237115_((String)this.m_5671_(stack));
        }
        MutableComponent potionName = Component.m_237115_((String)potion.m_43492_("item.minecraft.potion.effect."));
        return Component.m_237110_((String)(this.m_5671_(stack) + ".effect"), (Object[])new Object[]{potionName});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6047_()) {
            BlockHitResult hitResult;
            if (!level.f_46443_ && (hitResult = SlimePotionItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = hitResult.m_82425_();
                Direction face = hitResult.m_82434_();
                BlockState blockState = level.m_8055_(blockPos);
                BlockPos spawnPos = blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_121945_(face);
                if (level.m_8055_(spawnPos).m_60795_()) {
                    this.spawnMinions(level, spawnPos, player, itemstack);
                    this.spawnVFX(level, spawnPos);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
                    }
                    return InteractionResultHolder.m_19090_((Object)itemstack);
                }
            }
        } else {
            this.spawnProjectile(level, player, itemstack);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
                player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    private void spawnMinions(Level level, BlockPos pos, Player player, ItemStack stack) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        PotionSlimeEntity minion = new PotionSlimeEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.POTION_SLIME.get()), level);
        minion.setPotion(potion);
        SummonMethods.summonMinion(level, pos.m_7495_(), minion, this.getPotionDuration(potion) + 60, false, (LivingEntity)player);
    }

    private void spawnProjectile(Level level, Player player, ItemStack stack) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12437_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (!level.f_46443_) {
            SlimePotionProjectileEntity item = new SlimePotionProjectileEntity(level, (LivingEntity)player);
            item.setPotion(potion);
            item.m_37446_(stack);
            item.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.5f, 1.0f);
            level.m_7967_((Entity)item);
        }
    }

    private void spawnVFX(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_12436_, SoundSource.PLAYERS, 0.3f, 0.8f);
    }

    public int getPotionDuration(Potion potion) {
        if (potion == null || potion == Potions.f_43598_) {
            return 300;
        }
        if (potion.m_43491_()) {
            return 500;
        }
        List effects = potion.m_43488_();
        if (effects.isEmpty()) {
            return 1800;
        }
        MobEffectInstance effect = (MobEffectInstance)effects.get(0);
        return effect.m_19557_();
    }

    public static ItemStack withEffect(Potion potion) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SLIME_POTION.get());
        return PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
    }

    public static ItemStack withEffects(Collection<MobEffectInstance> effects) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SLIME_POTION.get());
        return PotionUtils.m_43552_((ItemStack)stack, effects);
    }
}

