/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mett.palemannie.quakeweapons.entity.client.BiosuitPowerupModel;
import mett.palemannie.quakeweapons.entity.custom.BiosuitPowerupEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BiosuitPowerupRenderer
extends EntityRenderer<BiosuitPowerupEntity> {
    private static final ResourceLocation BIOSUIT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quakeweapons", (String)"textures/entity/biosuit_powerup/biosuit_powerup.png");
    private final BiosuitPowerupModel<BiosuitPowerupEntity> model;
    float bobbingSpeed = 0.05f;
    float bobbingHeight = 0.1f;
    float rotationSpeed = 5.0f;

    public BiosuitPowerupRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BiosuitPowerupModel(context.m_174023_(BiosuitPowerupModel.BIOSUIT_LAYER));
    }

    public void render(BiosuitPowerupEntity rocketEntity, float v1, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 2.0f, 0.0f);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float ageInTicks = (float)rocketEntity.f_19797_ + partialTicks;
        double bob = Math.sin(ageInTicks * this.bobbingSpeed) * (double)this.bobbingHeight;
        poseStack.m_85837_(0.0, 0.25 + bob, 0.0);
        float rotation = ageInTicks * this.rotationSpeed % 360.0f;
        poseStack.m_252781_(Axis.f_252392_.m_252977_(rotation));
        VertexConsumer $$6 = bufferSource.m_6299_(this.model.m_103119_(BIOSUIT_LOCATION));
        this.model.m_7695_(poseStack, $$6, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer $$5 = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)BIOSUIT_LOCATION));
        this.model.m_7695_(poseStack, $$6, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)rocketEntity, v1, partialTicks, poseStack, bufferSource, packedLight);
    }

    public boolean shouldRender(BiosuitPowerupEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BiosuitPowerupEntity spit) {
        return BIOSUIT_LOCATION;
    }
}

