/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mett.palemannie.quakeweapons.entity.client.GrenadeProjectileModel;
import mett.palemannie.quakeweapons.entity.custom.GrenadeProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class GrenadeProjectileRenderer
extends EntityRenderer<GrenadeProjectileEntity> {
    private static final ResourceLocation GRENADE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quakeweapons", (String)"textures/entity/grenade_projectile/grenade_projectile.png");
    private static final ResourceLocation GRENADE_EMISSIVE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quakeweapons", (String)"textures/entity/grenade_projectile/grenade_projectile_glow.png");
    private final GrenadeProjectileModel<GrenadeProjectileEntity> model;

    public GrenadeProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new GrenadeProjectileModel(context.m_174023_(GrenadeProjectileModel.GRENADE_LAYER));
    }

    public void render(GrenadeProjectileEntity grenadeEntity, float v1, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        poseStack.m_252880_(0.0f, 0.1f, 0.0f);
        RandomSource random = RandomSource.m_216335_((long)grenadeEntity.m_19879_());
        if (!grenadeEntity.hasStopped) {
            float tumbleSpeed = -25.0f;
            float tumbleX = ((float)grenadeEntity.f_19797_ + partialTicks) * (tumbleSpeed + random.m_188501_() * (-tumbleSpeed * 2.0f));
            float tumbleY = ((float)grenadeEntity.f_19797_ + partialTicks) * (tumbleSpeed + random.m_188501_() * (-tumbleSpeed * 2.0f));
            float tumbleZ = ((float)grenadeEntity.f_19797_ + partialTicks) * (tumbleSpeed + random.m_188501_() * (-tumbleSpeed * 2.0f));
            grenadeEntity.lastTumbleX = tumbleX;
            grenadeEntity.lastTumbleY = tumbleY;
            grenadeEntity.lastTumbleZ = tumbleZ;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)grenadeEntity.f_19860_, (float)grenadeEntity.m_146909_()) + tumbleX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)grenadeEntity.f_19859_, (float)grenadeEntity.m_146908_()) + 180.0f + tumbleY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(tumbleZ));
        } else {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)grenadeEntity.f_19860_, (float)grenadeEntity.m_146909_()) + grenadeEntity.lastTumbleX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)grenadeEntity.f_19859_, (float)grenadeEntity.m_146908_()) + 180.0f + grenadeEntity.lastTumbleY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(grenadeEntity.lastTumbleZ));
        }
        VertexConsumer normal = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)GRENADE_LOCATION));
        this.model.m_7695_(poseStack, normal, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer emissive = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)GRENADE_EMISSIVE_LOCATION));
        this.model.m_7695_(poseStack, emissive, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)grenadeEntity, v1, partialTicks, poseStack, bufferSource, packedLight);
    }

    public boolean shouldRender(GrenadeProjectileEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GrenadeProjectileEntity spit) {
        return GRENADE_LOCATION;
    }
}

