/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mett.palemannie.quakeweapons.entity.client.PentagramPowerupModel;
import mett.palemannie.quakeweapons.entity.custom.PentagramPowerupEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class PentagramPowerupRenderer
extends EntityRenderer<PentagramPowerupEntity> {
    private static final ResourceLocation PENTAGRAM_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quakeweapons", (String)"textures/entity/pentagram_powerup/pentagram_powerup.png");
    private final PentagramPowerupModel<PentagramPowerupEntity> model;
    float bobbingSpeed = 0.05f;
    float bobbingHeight = 0.1f;
    float rotationSpeed = 5.0f;

    public PentagramPowerupRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PentagramPowerupModel(context.m_174023_(PentagramPowerupModel.PENTAGRAM_LAYER));
    }

    public void render(PentagramPowerupEntity rocketEntity, float v1, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        float ageInTicks = (float)rocketEntity.f_19797_ + partialTicks;
        double bob = Math.sin(ageInTicks * this.bobbingSpeed) * (double)this.bobbingHeight;
        poseStack.m_85837_(0.0, 0.25 + bob, 0.0);
        float rotation = ageInTicks * this.rotationSpeed % 360.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        VertexConsumer $$6 = bufferSource.m_6299_(this.model.m_103119_(PENTAGRAM_LOCATION));
        this.model.m_7695_(poseStack, $$6, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer $$5 = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)PENTAGRAM_LOCATION));
        this.model.m_7695_(poseStack, $$6, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)rocketEntity, v1, partialTicks, poseStack, bufferSource, packedLight);
    }

    public boolean shouldRender(PentagramPowerupEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PentagramPowerupEntity spit) {
        return PENTAGRAM_LOCATION;
    }
}

