/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.entity.custom;

import mett.palemannie.quakeweapons.effect.ModEffects;
import mett.palemannie.quakeweapons.sound.ModSounds;
import mett.palemannie.quakeweapons.util.ModDamageTypes;
import mett.palemannie.quakeweapons.util.QWConfigStats;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GrenadeProjectileEntity
extends Projectile {
    public float lastTumbleX = 0.0f;
    public float lastTumbleY = 0.0f;
    public float lastTumbleZ = 0.0f;
    public boolean hasStopped = false;

    public GrenadeProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
    }

    public boolean m_20068_() {
        return false;
    }

    public static float computeRadiusFromDamage(float configDamage, Player player) {
        if (player == null) {
            return (configDamage - 1.0f) / 7.0f / 2.0f;
        }
        return player.m_21023_((MobEffect)ModEffects.QUAD_DAMAGE.get()) ? (configDamage * 4.0f - 1.0f) / 7.0f / 2.0f : (configDamage - 1.0f) / 7.0f / 2.0f;
    }

    private void quakeExplosion(Level level) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 center = this.m_20182_();
        DamageSource source = level.m_269111_().m_268998_(ModDamageTypes.GRENADELAUNCHER_DAMAGE, null, null);
        AABB area = new AABB(this.m_20183_()).m_82400_((double)GrenadeProjectileEntity.computeRadiusFromDamage(QWConfigStats.GrenadelauncherDamage, (Player)this.m_19749_()));
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, area)) {
            if (entity == this.m_19749_()) continue;
            entity.m_6469_(this.m_269291_().m_268998_(DamageTypes.f_268464_, (Entity)this, this.m_19749_()), Float.MIN_VALUE);
        }
        this.m_9236_().m_255278_(null, source, null, center.f_82479_, center.f_82480_, center.f_82481_, GrenadeProjectileEntity.computeRadiusFromDamage(QWConfigStats.GrenadelauncherDamage, (Player)this.m_19749_()), false, Level.ExplosionInteraction.NONE, false);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_, center.f_82480_, center.f_82481_, 40, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, center.f_82479_, center.f_82480_, center.f_82481_, 20, 0.0, 0.0, 0.0, 0.1);
        this.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)ModSounds.EXPLOSION.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        this.m_146870_();
    }

    public void m_8119_() {
        EntityHitResult entityHit;
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        if (this.m_9236_().f_46443_) {
            Vec3 motion1 = this.m_20184_().m_82541_().m_82490_(-0.25);
            double px = this.m_20185_() + motion1.f_82479_;
            double py = this.m_20186_() + motion1.f_82480_;
            double pz = this.m_20189_() + motion1.f_82481_;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 0.0, 0.0, 0.0);
        }
        ClipContext ctx = new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(motion), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
        BlockHitResult blockHit = this.m_9236_().m_45547_(ctx);
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            this.m_8060_(blockHit);
            Vec3 normal = Vec3.m_82528_((Vec3i)blockHit.m_82434_().m_122436_());
            Vec3 bounced = motion.m_82546_(normal.m_82490_(2.0 * motion.m_82526_(normal)));
            float loss = 0.5f + this.f_19796_.m_188501_() * 0.25f;
            bounced = bounced.m_82490_((double)loss);
            if (bounced.m_82556_() < 0.04) {
                this.m_20256_(Vec3.f_82478_);
                this.f_19812_ = false;
            } else {
                this.m_20256_(bounced);
                this.f_19812_ = true;
            }
            this.m_146884_(blockHit.m_82450_());
        }
        if ((entityHit = ProjectileUtil.m_37287_((Entity)this, (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82549_(motion), (AABB)this.m_20191_().m_82369_(motion).m_82400_(0.3), x$0 -> this.m_5603_((Entity)x$0), (double)motion.m_82556_())) != null) {
            this.m_5790_(entityHit);
        }
        if (!this.m_20184_().equals((Object)Vec3.f_82478_)) {
            this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.06, 0.0));
        }
        if (this.f_19797_ > 50) {
            this.quakeExplosion(this.m_9236_());
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        Vec3 motion = this.m_20184_();
        double speed = motion.m_82553_();
        if (speed > 0.2 && !this.hasStopped) {
            this.m_5496_((SoundEvent)ModSounds.GRENADE_BOUNCE.get(), 2.0f, 1.0f);
        }
        if (speed < 0.2) {
            this.hasStopped = true;
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        this.quakeExplosion(this.m_9236_());
        this.m_146870_();
    }
}

