/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.entity.custom;

import mett.palemannie.quakeweapons.QuakeWeaponsConfig;
import mett.palemannie.quakeweapons.block.ModBlocks;
import mett.palemannie.quakeweapons.effect.ModEffects;
import mett.palemannie.quakeweapons.sound.ModSounds;
import mett.palemannie.quakeweapons.util.ModDamageTypes;
import mett.palemannie.quakeweapons.util.QWConfigStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class RocketProjectileEntity
extends Projectile {
    private BlockPos lightPos;

    public RocketProjectileEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
    }

    public boolean m_20068_() {
        return true;
    }

    public static float computeRadiusFromDamage(float configDamage, Player player) {
        if (player == null) {
            return (configDamage - 1.0f) / 7.0f / 2.0f;
        }
        return player.m_21023_((MobEffect)ModEffects.QUAD_DAMAGE.get()) ? (configDamage * 4.0f - 1.0f) / 7.0f / 2.0f : (configDamage - 1.0f) / 7.0f / 2.0f;
    }

    private void quakeExplosion(Level level) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 center = this.m_20182_();
        DamageSource source = level.m_269111_().m_268998_(ModDamageTypes.ROCKETLAUNCHER_DAMAGE, null, null);
        AABB area = new AABB(this.m_20183_()).m_82400_((double)RocketProjectileEntity.computeRadiusFromDamage(QWConfigStats.RocketlauncherDamage, (Player)this.m_19749_()));
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, area)) {
            if (entity == this.m_19749_()) continue;
            entity.m_6469_(this.m_269291_().m_268998_(DamageTypes.f_268464_, (Entity)this, this.m_19749_()), Float.MIN_VALUE);
        }
        this.m_9236_().m_255278_(null, source, null, center.f_82479_, center.f_82480_, center.f_82481_, RocketProjectileEntity.computeRadiusFromDamage(QWConfigStats.RocketlauncherDamage, (Player)this.m_19749_()), false, Level.ExplosionInteraction.NONE, false);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_, center.f_82480_, center.f_82481_, 40, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, center.f_82479_, center.f_82480_, center.f_82481_, 20, 0.0, 0.0, 0.0, 0.1);
        this.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)ModSounds.EXPLOSION.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        this.cleanupLight();
        this.m_146870_();
    }

    private void tryPlaceLight() {
        int[] dyOrder;
        BlockPos origin = this.m_20183_();
        Level level = this.m_9236_();
        for (int dy : dyOrder = new int[]{0, -1, 1}) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos candidate = origin.m_7918_(dx, dy, dz);
                    BlockState state = level.m_8055_(candidate);
                    if (state.m_60795_()) {
                        level.m_7731_(candidate, (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(15)), 3);
                        this.lightPos = candidate;
                        return;
                    }
                    if (state.m_60734_() != Blocks.f_49990_) continue;
                    level.m_7731_(candidate, ((Block)ModBlocks.LIGHT_WATER.get()).m_49966_(), 3);
                    this.lightPos = candidate;
                    return;
                }
            }
        }
    }

    private void cleanupLight() {
        if (this.lightPos != null) {
            BlockState state = this.m_9236_().m_8055_(this.lightPos);
            if (state.m_60734_() == Blocks.f_152480_) {
                this.m_9236_().m_7471_(this.lightPos, false);
            } else if (state.m_60734_() == ModBlocks.LIGHT_WATER.get()) {
                this.m_9236_().m_7731_(this.lightPos, Blocks.f_49990_.m_49966_(), 3);
            }
        }
    }

    void hitResultHandler() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    void projectileFlyStraight() {
        if (this.m_9236_().f_46443_) {
            Vec3 motion = this.m_20184_().m_82541_().m_82490_(-0.25);
            double px = this.m_20185_() + motion.f_82479_;
            double py = this.m_20186_() + motion.f_82480_;
            double pz = this.m_20189_() + motion.f_82481_;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, 0.0, 0.0, 0.0);
        }
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        this.m_20256_(vec3.m_82490_(1.0));
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0, 0.0));
        this.m_6034_(d0, d1, d2);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && ((Boolean)QuakeWeaponsConfig.COMMON.enableRocketTrailLight.get()).booleanValue() && this.f_19797_ % 2 == 0) {
            this.cleanupLight();
            this.tryPlaceLight();
        }
        this.hitResultHandler();
        this.projectileFlyStraight();
        if (this.f_19797_ > 400) {
            this.quakeExplosion(this.m_9236_());
            this.cleanupLight();
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
        this.quakeExplosion(this.m_9236_());
        this.cleanupLight();
        super.m_8060_(pResult);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Player player = (Player)this.m_19749_();
        pResult.m_82443_().m_6469_(this.m_9236_().m_269111_().m_268998_(DamageTypes.f_268464_, this.m_19749_(), this.m_19749_()), Float.MIN_VALUE);
        pResult.m_82443_().m_6469_(this.m_9236_().m_269111_().m_268998_(ModDamageTypes.ROCKETLAUNCHER_DAMAGE, null, null), player.m_21023_((MobEffect)ModEffects.QUAD_DAMAGE.get()) ? QWConfigStats.RocketlauncherDamage * RandomSource.m_216327_().m_188501_() / 4.0f * 4.0f : QWConfigStats.RocketlauncherDamage * RandomSource.m_216327_().m_188501_() / 4.0f);
        this.quakeExplosion(this.m_9236_());
        this.cleanupLight();
        this.m_146870_();
    }
}

