/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.event;

import java.util.List;
import mett.palemannie.quakeweapons.QuakeWeaponsConfig;
import mett.palemannie.quakeweapons.item.custom.AbstractWeapon;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quakeweapons", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AbstractWeaponItemDroppedAnimationFixer {
    private static double scanRadius = 20.0;
    private static long scanInterval = 5L;
    private static long tickCounter = 0L;

    public static void reloadConfigValues() {
        try {
            scanRadius = (Double)QuakeWeaponsConfig.SERVER.animationDroppedFixerSearchRadius.get();
            scanInterval = ((Integer)QuakeWeaponsConfig.SERVER.animationDroppedFixerSearchInterval.get()).intValue();
            System.out.println("[QuakeWeapons] Dropped Weapon Fixer Config reloaded: radius=" + scanRadius + ", interval=" + scanInterval);
        }
        catch (Exception e) {
            System.err.println("[QuakeWeapons] Failed to load dropped weapon fixer config values, using defaults!");
            scanRadius = 20.0;
            scanInterval = 5L;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.level;
        if (++tickCounter % scanInterval != 0L) {
            return;
        }
        for (ServerPlayer player : serverLevel.m_6907_()) {
            AABB scanBox = player.m_20191_().m_82400_(scanRadius);
            List nearbyItems = serverLevel.m_6443_(ItemEntity.class, scanBox, e -> true);
            for (ItemEntity itemEntity : nearbyItems) {
                ItemStack stack = itemEntity.m_32055_();
                Item item = stack.m_41720_();
                if (!(item instanceof AbstractWeapon)) continue;
                AbstractWeapon weapon = (AbstractWeapon)item;
                if (serverLevel.m_8890_() == null) continue;
                weapon.stopShootingAnimation((LivingEntity)serverLevel.m_8890_(), serverLevel, stack);
                weapon.stopAmmoEmptyAnimation((LivingEntity)serverLevel.m_8890_(), serverLevel, stack);
                weapon.stopIdleAnimation((LivingEntity)serverLevel.m_8890_(), serverLevel, stack);
            }
        }
    }
}

