/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.event;

import java.util.function.Consumer;
import mett.palemannie.quakeweapons.QuakeWeaponsConfig;
import mett.palemannie.quakeweapons.entity.ModEntities;
import mett.palemannie.quakeweapons.entity.custom.AbstractPowerupEntity;
import mett.palemannie.quakeweapons.entity.custom.BiosuitPowerupEntity;
import mett.palemannie.quakeweapons.entity.custom.PentagramPowerupEntity;
import mett.palemannie.quakeweapons.entity.custom.QuadDamagePowerupEntity;
import mett.palemannie.quakeweapons.entity.custom.RingofshadowsPowerupEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="quakeweapons", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PowerupSpawner {
    private static int spawnInterval = 600;
    private static int spawnAttempts = 3;
    private static int searchRadius = 5;
    private static boolean debugEnabled = false;
    private static boolean powerupSpawningEnabled = true;
    private static long tickCounter = 0L;

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent event) {
        if (event.getConfig().getSpec() == QuakeWeaponsConfig.SERVER_SPEC) {
            PowerupSpawner.reloadConfigValues();
        }
    }

    public static void reloadConfigValues() {
        try {
            spawnInterval = (Integer)QuakeWeaponsConfig.SERVER.powerupSpawnInterval.get();
            spawnAttempts = (Integer)QuakeWeaponsConfig.SERVER.powerupSpawnAttempts.get();
            searchRadius = (Integer)QuakeWeaponsConfig.SERVER.powerupSpawnSearchRadius.get();
            debugEnabled = (Boolean)QuakeWeaponsConfig.SERVER.powerupDebug.get();
            powerupSpawningEnabled = (Boolean)QuakeWeaponsConfig.SERVER.enablePowerups.get();
            System.out.println("[QuakeWeapons] PowerupSpawner config reloaded:");
            System.out.println(" interval=" + spawnInterval + " | attempts=" + spawnAttempts + " | radius=" + searchRadius + " | debug=" + debugEnabled + " | enablePowerups=" + powerupSpawningEnabled);
        }
        catch (Exception e) {
            System.err.println("[QuakeWeapons] Failed to load config values, using defaults!");
            spawnInterval = 600;
            spawnAttempts = 3;
            searchRadius = 5;
            debugEnabled = false;
            powerupSpawningEnabled = true;
        }
        System.out.println("[QuakeWeapons] Config values after load: powerupSpawnInterval:" + QuakeWeaponsConfig.SERVER.powerupSpawnInterval.get() + ", powerupSpawnAttempts:" + QuakeWeaponsConfig.SERVER.powerupSpawnAttempts.get() + ", powerupSpawnSearchRadius:" + QuakeWeaponsConfig.SERVER.powerupSpawnSearchRadius.get() + ", enablePowerups:" + QuakeWeaponsConfig.SERVER.enablePowerups.get() + ", powerupDebug;" + QuakeWeaponsConfig.SERVER.powerupDebug.get());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!powerupSpawningEnabled) {
            if (debugEnabled) {
                System.err.println("POWERUP SPAWNING DISABLED. DISABLE DEBUG MODE IN SERVER CONFIG OR ENABLE POWERUP SPAWNING");
            }
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_) {
            return;
        }
        int interval = spawnInterval;
        int attempts = spawnAttempts;
        ServerLevel level = (ServerLevel)event.level;
        long gameTime = level.m_46467_();
        if (gameTime % (long)interval != 0L) {
            return;
        }
        for (ServerPlayer player : level.m_6907_()) {
            for (int i = 0; i < attempts; ++i) {
                PowerupSpawner.trySpawnNearPlayer(level, player);
            }
        }
    }

    private static void trySpawnNearPlayer(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.f_46441_;
        int x = player.m_20183_().m_123341_() + Mth.m_216271_((RandomSource)random, (int)-128, (int)128);
        int z = player.m_20183_().m_123343_() + Mth.m_216271_((RandomSource)random, (int)-128, (int)128);
        int y = Mth.m_216271_((RandomSource)random, (int)(level.m_141937_() + 5), (int)(level.m_151558_() - 5));
        BlockPos candidate = new BlockPos(x, y, z);
        if (PowerupSpawner.tryFindSpawnPos(level, candidate, searchRadius, searchRadius, pos -> {
            AbstractPowerupEntity entity = PowerupSpawner.randomPowerup(level);
            entity.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)entity);
            PowerupSpawner.debug(level, "\u00a7aSpawned " + entity.m_6095_().m_147048_() + " at " + pos);
        })) {
            return;
        }
        PowerupSpawner.debug(level, "\u00a7cNo valid spawn near " + candidate);
    }

    private static boolean tryFindSpawnPos(ServerLevel level, BlockPos center, int radius, int yRadius, Consumer<BlockPos> onFound) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dy = -yRadius; dy <= yRadius; ++dy) {
                    BlockPos pos = center.m_7918_(dx, dy, dz);
                    BlockState above = level.m_8055_(pos);
                    BlockState below = level.m_8055_(pos.m_7495_());
                    if (!above.m_60795_() || !below.m_280296_() && !below.m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) continue;
                    onFound.accept(pos);
                    return true;
                }
            }
        }
        return false;
    }

    private static AbstractPowerupEntity randomPowerup(ServerLevel level) {
        return switch (level.f_46441_.m_188503_(4)) {
            case 0 -> new QuadDamagePowerupEntity((EntityType<? extends QuadDamagePowerupEntity>)((EntityType)ModEntities.QUAD_DAMAGE_POWERUP.get()), (Level)level);
            case 1 -> new PentagramPowerupEntity((EntityType<? extends PentagramPowerupEntity>)((EntityType)ModEntities.PENTAGRAM_POWERUP.get()), (Level)level);
            case 2 -> new BiosuitPowerupEntity((EntityType<? extends BiosuitPowerupEntity>)((EntityType)ModEntities.BIOSUIT_POWERUP.get()), (Level)level);
            default -> new RingofshadowsPowerupEntity((EntityType<? extends RingofshadowsPowerupEntity>)((EntityType)ModEntities.RING_POWERUP.get()), (Level)level);
        };
    }

    private static void debug(ServerLevel level, String msg) {
        if (!debugEnabled) {
            return;
        }
        MutableComponent comp = Component.m_237113_((String)("\u00a7d[PowerupSpawner]\u00a7r " + msg));
        for (ServerPlayer sp : level.m_6907_()) {
            sp.m_213846_((Component)comp);
        }
        System.out.println("[PowerupSpawner] " + msg.replaceAll("\u00a7.", ""));
    }
}

