/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.item.custom;

import mett.palemannie.quakeweapons.effect.ModEffects;
import mett.palemannie.quakeweapons.item.custom.NailgunItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractWeapon
extends Item
implements GeoItem {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    int cooldown;

    public AbstractWeapon(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setCurrentHand(InteractionHand hand, LivingEntity player) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_41619_() && !player.m_6117_()) {
            player.f_20935_ = itemStack;
            player.f_20936_ = itemStack.m_41779_();
            if (!player.m_9236_().m_5776_()) {
                player.m_21155_(1, true);
                player.m_21155_(2, hand == InteractionHand.OFF_HAND);
                player.m_146850_(GameEvent.f_223698_);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 2000000000;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.m_21195_((MobEffect)ModEffects.QW_INVIS.get());
        pPlayer.m_6842_(false);
        if (pUsedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
        }
        this.setCurrentHand(pUsedHand, (LivingEntity)pPlayer);
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
    }

    protected abstract void executeWeaponFire(Level var1, LivingEntity var2, ItemStack var3, int var4);

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        this.executeWeaponFire(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
    }

    public void m_5551_(ItemStack stack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        super.m_5551_(stack, pLevel, pLivingEntity, pTimeCharged);
        if (pLivingEntity instanceof Player) {
            ((Player)pLivingEntity).m_36335_().m_41524_((Item)this, this.cooldown);
        }
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            this.stopShootingAnimation(pLivingEntity, serverLevel, stack);
            this.stopAmmoEmptyAnimation(pLivingEntity, serverLevel, stack);
            this.startIdleAnimation(pLivingEntity, serverLevel, stack);
        }
        NailgunItem.rightSide = false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (stack.m_41782_() && stack.m_41783_().m_128471_("WasDropped")) {
                    this.stopShootingAnimation((LivingEntity)entity, serverLevel, stack);
                    this.stopAmmoEmptyAnimation((LivingEntity)entity, serverLevel, stack);
                    this.startIdleAnimation((LivingEntity)entity, serverLevel, stack);
                    stack.m_41783_().m_128473_("WasDropped");
                }
                if (!selected || !player.m_6117_()) {
                    this.stopShootingAnimation((LivingEntity)entity, serverLevel, stack);
                    this.stopAmmoEmptyAnimation((LivingEntity)entity, serverLevel, stack);
                    this.startIdleAnimation((LivingEntity)entity, serverLevel, stack);
                }
                super.m_6883_(stack, level, entity, slot, selected);
            }
        }
    }

    public void startShootingAnimation(LivingEntity pLivingEntity, ServerLevel serverLevel, ItemStack stack) {
        this.triggerAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "shooting");
    }

    public void stopShootingAnimation(LivingEntity pLivingEntity, ServerLevel serverLevel, ItemStack stack) {
        this.stopTriggeredAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "shooting");
    }

    public void startAmmoEmptyAnimation(LivingEntity pLivingEntity, ServerLevel serverLevel, ItemStack stack) {
        this.triggerAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller2", "ammoempty");
    }

    public void stopAmmoEmptyAnimation(LivingEntity pLivingEntity, ServerLevel serverLevel, ItemStack stack) {
        this.stopTriggeredAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller2", "ammoempty");
    }

    public void startIdleAnimation(LivingEntity pLivingEntity, ServerLevel serverLevel, ItemStack stack) {
        this.triggerAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller3", "idle");
    }

    public void stopIdleAnimation(LivingEntity pLivingEntity, ServerLevel serverLevel, ItemStack stack) {
        this.stopTriggeredAnim((Entity)pLivingEntity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller3", "idle");
    }
}

