/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.item.custom;

import java.util.function.Consumer;
import mett.palemannie.quakeweapons.item.ModItems;
import mett.palemannie.quakeweapons.item.client.RocketlauncherRenderer;
import mett.palemannie.quakeweapons.item.custom.AbstractWeapon;
import mett.palemannie.quakeweapons.util.ServerPlayHandler;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RocketlauncherItem
extends AbstractWeapon {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SHOOT_ANIM = RawAnimation.begin().then("rocketlauncher.animations.shooting", Animation.LoopType.LOOP);
    private static final RawAnimation AMMOEMPTY_ANIM = RawAnimation.begin().then("rocketlauncher.animations.ammoempty", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().then("rocketlauncher.animations.idle", Animation.LoopType.LOOP);

    public RocketlauncherItem(Item.Properties pProperties) {
        super(pProperties);
        this.cooldown = 14;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE).triggerableAnim("shooting", SHOOT_ANIM)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, state -> PlayState.CONTINUE).triggerableAnim("ammoempty", AMMOEMPTY_ANIM)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 0, state -> PlayState.CONTINUE).triggerableAnim("idle", IDLE_ANIM)});
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private RocketlauncherRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RocketlauncherRenderer();
                }
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.m_41619_() && entityLiving.m_21120_(hand) == itemStack) {
                    return HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }
        });
    }

    private boolean consumeAmmo(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)ModItems.ROCKET.get())) continue;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    @Override
    protected void executeWeaponFire(Level level, LivingEntity user, ItemStack stack, int pRemainingUseDuration) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            if (pRemainingUseDuration % 16 == 0) {
                if (this.consumeAmmo((Player)user)) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        this.stopAmmoEmptyAnimation(user, serverLevel, stack);
                        this.stopIdleAnimation(user, serverLevel, stack);
                        this.startShootingAnimation(user, serverLevel, stack);
                    }
                    ServerPlayHandler.handleRocketLauncherShoot(serverPlayer);
                } else {
                    ServerPlayHandler.playAmmoEmptySound(serverPlayer);
                    this.stopShootingAnimation(user, level.m_7654_().m_129783_(), stack);
                    this.stopIdleAnimation(user, level.m_7654_().m_129783_(), stack);
                    this.startAmmoEmptyAnimation(user, level.m_7654_().m_129783_(), stack);
                }
            }
        }
    }
}

