/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.item.custom;

import java.util.List;
import java.util.function.Consumer;
import mett.palemannie.quakeweapons.effect.ModEffects;
import mett.palemannie.quakeweapons.item.ModItems;
import mett.palemannie.quakeweapons.item.client.ThunderboltRenderer;
import mett.palemannie.quakeweapons.item.custom.AbstractWeapon;
import mett.palemannie.quakeweapons.sound.ModSounds;
import mett.palemannie.quakeweapons.util.ModDamageTypes;
import mett.palemannie.quakeweapons.util.QWConfigStats;
import mett.palemannie.quakeweapons.util.ServerPlayHandler;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ThunderboltItem
extends AbstractWeapon {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SHOOT_ANIM = RawAnimation.begin().then("thunderbolt.animations.shooting", Animation.LoopType.LOOP);
    private static final RawAnimation AMMOEMPTY_ANIM = RawAnimation.begin().then("thunderbolt.animations.ammoempty", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().then("thunderbolt.animations.idle", Animation.LoopType.LOOP);

    public ThunderboltItem(Item.Properties pProperties) {
        super(pProperties);
        this.cooldown = 1;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE).triggerableAnim("shooting", SHOOT_ANIM)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, state -> PlayState.CONTINUE).triggerableAnim("ammoempty", AMMOEMPTY_ANIM)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 0, state -> PlayState.CONTINUE).triggerableAnim("idle", IDLE_ANIM)});
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ThunderboltRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ThunderboltRenderer();
                }
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.m_41619_() && entityLiving.m_21120_(hand) == itemStack) {
                    return HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }
        });
    }

    private boolean consumeAmmo(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)ModItems.CELL.get())) continue;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    private void triggerWaterDischarge(ServerLevel level, Player player) {
        if (level.f_46443_) {
            return;
        }
        int cellCount = this.countAmmoCells(player);
        double radius = (double)cellCount / 2.0;
        Vec3 dischargePos = player.m_20182_();
        AABB area = new AABB(dischargePos.f_82479_ - radius, dischargePos.f_82480_ - radius, dischargePos.f_82481_ - radius, dischargePos.f_82479_ + radius, dischargePos.f_82480_ + radius, dischargePos.f_82481_ + radius);
        List targets = level.m_6443_(LivingEntity.class, area, e -> e.m_6084_() && e != player);
        this.removeAllAmmoCells(player);
        for (LivingEntity target : targets) {
            boolean targetInWater = target.m_20072_();
            boolean hasLOS = this.hasLineOfSight((Level)level, dischargePos, target);
            if (!targetInWater && !hasLOS) continue;
            target.m_6469_(level.m_269111_().m_269075_(player), Float.MIN_VALUE);
            target.m_6469_(level.m_269111_().m_268998_(ModDamageTypes.THUNDERBOLT_DISCHARGE, null, null), player.m_21023_((MobEffect)ModEffects.QUAD_DAMAGE.get()) ? (float)cellCount * 0.66f * QWConfigStats.ThunderboltDamage * 4.0f : (float)cellCount * 0.66f * QWConfigStats.ThunderboltDamage);
            level.m_5594_(null, target.m_20183_(), (SoundEvent)ModSounds.THUNDERBOLT_LOOP.get(), SoundSource.PLAYERS, 0.5f, 0.5f);
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 12, 0.2, 0.5, 0.2, 0.05);
        }
        player.m_6469_(level.m_269111_().m_268998_(ModDamageTypes.THUNDERBOLT_DISCHARGE, (Entity)player, (Entity)player), (float)cellCount * 0.5f * QWConfigStats.ThunderboltDamage);
        level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.THUNDERBOLT_LOOP.get(), SoundSource.PLAYERS, 0.5f, 0.5f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), 12, 0.2, 0.5, 0.2, 0.05);
    }

    private boolean hasLineOfSight(Level level, Vec3 from, LivingEntity target) {
        Vec3 to = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        BlockHitResult hit = level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return hit.m_6662_() == HitResult.Type.MISS;
    }

    private int countAmmoCells(Player player) {
        int total = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)ModItems.CELL.get())) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    private void removeAllAmmoCells(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)ModItems.CELL.get())) continue;
            stack.m_41764_(0);
        }
    }

    @Override
    protected void executeWeaponFire(Level level, LivingEntity user, ItemStack stack, int pRemainingUseDuration) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            if (pRemainingUseDuration % 2 == 0) {
                if (this.consumeAmmo((Player)user)) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (user.m_20072_()) {
                            this.triggerWaterDischarge(serverLevel, (Player)user);
                        }
                        this.stopAmmoEmptyAnimation(user, serverLevel, stack);
                        this.stopIdleAnimation(user, serverLevel, stack);
                        this.startShootingAnimation(user, serverLevel, stack);
                    }
                    ServerPlayHandler.handleThunderboltShoot(serverPlayer, this.m_8105_(stack) - pRemainingUseDuration);
                } else {
                    ServerPlayHandler.playAmmoEmptySound(serverPlayer);
                    this.stopShootingAnimation(user, level.m_7654_().m_129783_(), stack);
                    this.stopIdleAnimation(user, level.m_7654_().m_129783_(), stack);
                    this.startAmmoEmptyAnimation(user, level.m_7654_().m_129783_(), stack);
                }
            }
        }
    }
}

