/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.net.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class S2CInvisPacket {
    private final int entityId;
    private final boolean invisible;

    public S2CInvisPacket(int entityId, boolean invisible) {
        this.entityId = entityId;
        this.invisible = invisible;
    }

    public static void encode(S2CInvisPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeBoolean(msg.invisible);
    }

    public static S2CInvisPacket decode(FriendlyByteBuf buf) {
        return new S2CInvisPacket(buf.readInt(), buf.readBoolean());
    }

    public static void handle(S2CInvisPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> S2CInvisPacket.handleClient(msg));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(S2CInvisPacket msg) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity e = level.m_6815_(msg.entityId);
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            living.getPersistentData().m_128379_("QWInvis", msg.invisible);
        }
    }
}

