/*
 * Decompiled with CFR 0.152.
 */
package mett.palemannie.quakeweapons.util;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import mett.palemannie.quakeweapons.QuakeWeaponsConfig;
import mett.palemannie.quakeweapons.entity.ModEntities;
import mett.palemannie.quakeweapons.entity.custom.GrenadeProjectileEntity;
import mett.palemannie.quakeweapons.entity.custom.MuzzleflashEntity;
import mett.palemannie.quakeweapons.entity.custom.NailProjectileEntity;
import mett.palemannie.quakeweapons.entity.custom.RocketProjectileEntity;
import mett.palemannie.quakeweapons.entity.custom.SuperNailProjectileEntity;
import mett.palemannie.quakeweapons.item.custom.NailgunItem;
import mett.palemannie.quakeweapons.sound.ModSounds;
import mett.palemannie.quakeweapons.util.ModDamageTypes;
import mett.palemannie.quakeweapons.util.QWConfigStats;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class ServerPlayHandler {
    private static boolean isMuzzleFlashEnabled() {
        return (Boolean)QuakeWeaponsConfig.COMMON.enableMuzzleFlash.get();
    }

    private static Vec3 getShotgunNormalizedSpreadDirection(Vec3 look, double spreadDegrees, RandomSource random) {
        double spreadRad = Math.toRadians(spreadDegrees);
        double angle = random.m_188500_() * Math.PI * 2.0;
        double radius = random.m_188500_() * Math.sin(spreadRad);
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 right = look.m_82537_(up).m_82541_();
        up = right.m_82537_(look).m_82541_();
        Vec3 offset = right.m_82490_(Math.cos(angle) * radius).m_82549_(up.m_82490_(Math.sin(angle) * radius));
        return look.m_82549_(offset).m_82541_();
    }

    private static Vec3 getSuperShotgunNormalizedSpreadDirection(Vec3 forward, double spreadH, double spreadV, RandomSource random) {
        double yaw = Math.toRadians((random.m_188500_() - 0.5) * 2.0 * spreadH);
        double pitch = Math.toRadians((random.m_188500_() - 0.5) * 2.0 * spreadV);
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 right = forward.m_82537_(up).m_82541_();
        up = right.m_82537_(forward).m_82541_();
        Vec3 dir = forward.m_82549_(right.m_82490_(Math.tan(yaw))).m_82549_(up.m_82490_(Math.tan(pitch)));
        return dir.m_82541_();
    }

    private static void shootFromRotationNoMomentum(Projectile projectile, ServerPlayer player, float xRot, float yRot, float velocity, float inaccuracy) {
        projectile.m_5602_((Entity)player);
        projectile.m_6034_(player.m_146892_().f_82479_, player.m_20188_() - 0.2, player.m_146892_().f_82481_);
        float f = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)(xRot * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        projectile.m_146922_(player.m_146908_());
        projectile.f_19859_ = player.m_146908_();
        projectile.m_146926_(player.m_146909_());
        projectile.f_19860_ = player.m_146909_();
        projectile.m_6686_((double)f, (double)f1, (double)f2, velocity, inaccuracy);
    }

    public static void handleAxeShoot(Player player) {
        Predicate<Entity> canHit;
        AABB pathBB;
        EntityHitResult entityHit;
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        double reach = 3.0;
        if (player.m_21204_().m_22171_((Attribute)ForgeMod.ENTITY_REACH.get())) {
            reach = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()).m_22135_();
        }
        Vec3 eye = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = eye.m_82549_(look.m_82490_(reach));
        BlockHitResult blockHit = level.m_45547_(new ClipContext(eye, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 maxEnd = end;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            maxEnd = blockHit.m_82450_();
        }
        if ((entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)eye, (Vec3)maxEnd, (AABB)(pathBB = new AABB(eye, maxEnd).m_82400_(0.25)), canHit = e -> e.m_6084_() && e.m_6087_() && e instanceof LivingEntity && e != player)) != null) {
            LivingEntity target = (LivingEntity)entityHit.m_82443_();
            target.m_6469_(level.m_269111_().m_268998_(ModDamageTypes.AXE_DAMAGE, (Entity)player, (Entity)player), QWConfigStats.AxeDamage);
            Vec3 p = entityHit.m_82450_();
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, p.f_82479_, p.f_82480_, p.f_82481_, 6, 0.2, 0.2, 0.2, 0.1);
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, p.f_82479_, p.f_82480_, p.f_82481_, 3, 0.0, 0.2, 0.2, 0.2);
            if (((Boolean)QuakeWeaponsConfig.COMMON.enableGore.get()).booleanValue()) {
                sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123802_, p.f_82479_, p.f_82480_, p.f_82481_, 4, 0.5, 0.5, 0.5, 0.0);
            }
            level.m_6263_(null, p.f_82479_, p.f_82480_, p.f_82481_, (SoundEvent)ModSounds.AXE_HIT_ENTITY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_6263_(null, p.f_82479_, p.f_82480_, p.f_82481_, (SoundEvent)ModSounds.AXE_HIT_AIR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (blockHit.m_6662_() != HitResult.Type.MISS) {
            Vec3 hitP = blockHit.m_82450_();
            Vec3 n = Vec3.m_82528_((Vec3i)blockHit.m_82434_().m_122436_()).m_82541_();
            Vec3 spawn = hitP.m_82549_(n.m_82490_(0.01));
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            level.m_6263_(null, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, (SoundEvent)ModSounds.AXE_HIT_AIR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_6263_(null, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, (SoundEvent)ModSounds.AXE_HIT_SOLID.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.AXE_HIT_AIR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void handleThunderboltShoot(ServerPlayer player, int useTime) {
        Level lvl = player.m_9236_();
        ServerLevel sevel = player.m_284548_();
        double forwardOffset = 0.2;
        Vec3 look1 = player.m_20154_();
        Vec3 right = look1.m_82537_(new Vec3(0.0, 0.0, 0.0)).m_82541_();
        double spawnX = player.m_20185_() + right.f_82479_ + look1.f_82479_ * forwardOffset;
        double spawnY = player.m_20188_() - 0.25 + right.f_82480_ + look1.f_82480_ * forwardOffset;
        double spawnZ = player.m_20189_() + right.f_82481_ + look1.f_82481_ * forwardOffset;
        if (ServerPlayHandler.isMuzzleFlashEnabled()) {
            MuzzleflashEntity flash = new MuzzleflashEntity((Level)sevel, (Player)player);
            flash.m_6034_(spawnX, spawnY, spawnZ);
            flash.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.0f, 0.0f);
            sevel.m_7967_((Entity)flash);
        }
        double maxDistance = 20.0;
        Vec3 start = player.m_146892_();
        Vec3 look = player.m_20154_();
        HashSet<LivingEntity> alreadyHit = new HashSet<LivingEntity>();
        for (double i = 0.0; i < maxDistance; i += 0.25) {
            Vec3 point = start.m_82549_(look.m_82490_(i));
            AABB box = new AABB(point.f_82479_ - 0.25, point.f_82480_ - 0.25, point.f_82481_ - 0.25, point.f_82479_ + 0.25, point.f_82480_ + 0.25, point.f_82481_ + 0.25);
            List entities = lvl.m_45976_(LivingEntity.class, box);
            for (LivingEntity target : entities) {
                if (target == player || !target.m_6084_() || alreadyHit.contains(target)) continue;
                alreadyHit.add(target);
                target.m_6469_(lvl.m_269111_().m_268998_(ModDamageTypes.THUNDERBOLT_DAMAGE, (Entity)player, (Entity)player), QWConfigStats.ThunderboltDamage);
            }
            if (!((Boolean)QuakeWeaponsConfig.COMMON.enableThunderboltTracer.get()).booleanValue()) continue;
            player.m_20194_().m_129783_().m_8767_((ParticleOptions)ParticleTypes.f_175830_, point.f_82479_, point.f_82480_ - 0.25, point.f_82481_, 1, (double)0.02f, (double)0.02f, (double)0.02f, 0.0);
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        if (useTime < 2) {
            lvl.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.THUNDERBOLT_START.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (useTime % 12 == 0) {
            lvl.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.THUNDERBOLT_LOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void handleRocketLauncherShoot(ServerPlayer player) {
        ServerLevel sevel = player.m_284548_();
        Level lvl = player.m_9236_();
        double forwardOffset = 0.2;
        Vec3 look = player.m_20154_();
        Vec3 right = look.m_82537_(new Vec3(0.0, 0.0, 0.0)).m_82541_();
        double spawnX = player.m_20185_() + right.f_82479_ + look.f_82479_ * forwardOffset;
        double spawnY = player.m_20188_() - (double)0.2f + right.f_82480_ + look.f_82480_ * forwardOffset;
        double spawnZ = player.m_20189_() + right.f_82481_ + look.f_82481_ * forwardOffset;
        RocketProjectileEntity rocket = new RocketProjectileEntity((EntityType<? extends Projectile>)((EntityType)ModEntities.ROCKET_PROJECTILE.get()), (Level)sevel);
        ServerPlayHandler.shootFromRotationNoMomentum(rocket, player, player.m_146909_(), player.m_146908_(), 1.0f, 0.0f);
        sevel.m_7967_((Entity)rocket);
        if (ServerPlayHandler.isMuzzleFlashEnabled()) {
            MuzzleflashEntity flash = new MuzzleflashEntity((Level)sevel, (Player)player);
            flash.m_6034_(spawnX, spawnY, spawnZ);
            sevel.m_7967_((Entity)flash);
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        lvl.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.ROCKETLAUNCHER_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void handleGrenadeLauncherShoot(ServerPlayer player) {
        ServerLevel sevel = player.m_284548_();
        Level lvl = player.m_9236_();
        GrenadeProjectileEntity grenade = new GrenadeProjectileEntity((EntityType<? extends Projectile>)((EntityType)ModEntities.GRENADE_PROJECTILE.get()), (Level)sevel);
        ServerPlayHandler.shootFromRotationNoMomentum(grenade, player, player.m_146909_(), player.m_146908_(), 0.8f, 0.0f);
        sevel.m_7967_((Entity)grenade);
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        lvl.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.GRENADELAUNCHER_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void handleSuperShotgunShoot(ServerPlayer player) {
        ServerLevel sevel = player.m_284548_();
        Vec3 eyePos = player.m_146892_();
        Vec3 look = player.m_20154_();
        int PELLETS = 14;
        double RANGE = 64.0;
        double SPREAD_H = 11.0;
        double SPREAD_V = 7.0;
        float DAMAGE_PER_PELLET = QWConfigStats.SuperShotgunDamage;
        for (int i = 0; i < 14; ++i) {
            Vec3 pelletDir = ServerPlayHandler.getSuperShotgunNormalizedSpreadDirection(look, 11.0, 7.0, sevel.f_46441_);
            Vec3 endPos = eyePos.m_82549_(pelletDir.m_82490_(64.0));
            BlockHitResult blockHit = sevel.m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)sevel, (Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)new AABB(eyePos, endPos).m_82400_(1.0), e -> e instanceof LivingEntity && e != player);
            if (entityHit != null && (blockHit == null || entityHit.m_82450_().m_82554_(eyePos) < blockHit.m_82450_().m_82554_(eyePos))) {
                LivingEntity target = (LivingEntity)entityHit.m_82443_();
                target.m_6469_(sevel.m_269111_().m_268998_(ModDamageTypes.SUPER_SHOTGUN_DAMAGE, (Entity)player, (Entity)player), DAMAGE_PER_PELLET);
                Vec3 hitPos = entityHit.m_82450_();
                if (((Boolean)QuakeWeaponsConfig.COMMON.enableGore.get()).booleanValue()) {
                    sevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123802_, true, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.5, 0.5, 0.5, 0.0);
                }
                sevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, true, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.5, 0.5, 0.5, 0.0);
                continue;
            }
            if (blockHit == null || blockHit.m_6662_() == HitResult.Type.MISS) continue;
            Vec3 hitPos = blockHit.m_82450_();
            sevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        sevel.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.SUPER_SHOTGUN_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        double forwardOffset = 0.2;
        Vec3 look1 = player.m_20154_();
        Vec3 right = look1.m_82537_(new Vec3(0.0, 0.0, 0.0)).m_82541_();
        double spawnX = player.m_20185_() + right.f_82479_ + look1.f_82479_ * forwardOffset;
        double spawnY = player.m_20188_() - 0.25 + right.f_82480_ + look1.f_82480_ * forwardOffset;
        double spawnZ = player.m_20189_() + right.f_82481_ + look1.f_82481_ * forwardOffset;
        if (ServerPlayHandler.isMuzzleFlashEnabled()) {
            MuzzleflashEntity flash = new MuzzleflashEntity((Level)sevel, (Player)player);
            flash.m_6034_(spawnX, spawnY, spawnZ);
            sevel.m_7967_((Entity)flash);
        }
    }

    public static void handleShotgunShoot(ServerPlayer player) {
        ServerLevel sevel = player.m_284548_();
        Level level = player.m_9236_();
        int PELLETS = 6;
        float DAMAGE_PER_PELLET = QWConfigStats.ShotgunDamage;
        double RANGE = 64.0;
        double SPREAD_DEGREES = 10.0;
        Vec3 eyePos = player.m_146892_();
        Vec3 look = player.m_20154_();
        for (int i = 0; i < 6; ++i) {
            Vec3 pelletDir = ServerPlayHandler.getShotgunNormalizedSpreadDirection(look, 10.0, level.f_46441_);
            Vec3 endPos = eyePos.m_82549_(pelletDir.m_82490_(64.0));
            BlockHitResult blockHit = level.m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)new AABB(eyePos, endPos).m_82400_(1.0), e -> e instanceof LivingEntity && e != player);
            if (entityHit != null && (blockHit == null || entityHit.m_82450_().m_82554_(eyePos) < blockHit.m_82450_().m_82554_(eyePos))) {
                LivingEntity target = (LivingEntity)entityHit.m_82443_();
                target.m_6469_(level.m_269111_().m_268998_(ModDamageTypes.SHOTGUN_DAMAGE, (Entity)player, (Entity)player), DAMAGE_PER_PELLET);
                Vec3 hitPos = entityHit.m_82450_();
                if (((Boolean)QuakeWeaponsConfig.COMMON.enableGore.get()).booleanValue()) {
                    sevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123802_, true, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.5, 0.5, 0.5, 0.0);
                }
                sevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, true, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.5, 0.5, 0.5, 0.0);
                continue;
            }
            if (blockHit == null || blockHit.m_6662_() == HitResult.Type.MISS) continue;
            Vec3 hitPos = blockHit.m_82450_();
            sevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, true, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        level.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.SHOTGUN_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        double forwardOffset = 0.2;
        Vec3 look1 = player.m_20154_();
        Vec3 right = look1.m_82537_(new Vec3(0.0, 0.0, 0.0)).m_82541_();
        double spawnX = player.m_20185_() + right.f_82479_ + look1.f_82479_ * forwardOffset;
        double spawnY = player.m_20188_() - 0.25 + right.f_82480_ + look1.f_82480_ * forwardOffset;
        double spawnZ = player.m_20189_() + right.f_82481_ + look1.f_82481_ * forwardOffset;
        if (ServerPlayHandler.isMuzzleFlashEnabled()) {
            MuzzleflashEntity flash = new MuzzleflashEntity((Level)sevel, (Player)player);
            flash.m_6034_(spawnX, spawnY, spawnZ);
            sevel.m_7967_((Entity)flash);
        }
    }

    public static void handleSuperNailgunShoot(ServerPlayer player) {
        ServerLevel sevel = player.m_284548_();
        Level lvl = player.m_9236_();
        double forwardOffset = 0.2;
        Vec3 look = player.m_20154_();
        Vec3 right = look.m_82537_(new Vec3(0.0, 0.0, 0.0)).m_82541_();
        double spawnX = player.m_20185_() + right.f_82479_ + look.f_82479_ * forwardOffset;
        double spawnY = player.m_20188_() - 0.25 + right.f_82480_ + look.f_82480_ * forwardOffset;
        double spawnZ = player.m_20189_() + right.f_82481_ + look.f_82481_ * forwardOffset;
        SuperNailProjectileEntity supernail = new SuperNailProjectileEntity((EntityType<? extends Projectile>)((EntityType)ModEntities.SUPER_NAIL_PROJECTILE.get()), (Level)sevel);
        ServerPlayHandler.shootFromRotationNoMomentum(supernail, player, player.m_146909_(), player.m_146908_(), 1.0f, 0.0f);
        sevel.m_7967_((Entity)supernail);
        if (ServerPlayHandler.isMuzzleFlashEnabled()) {
            MuzzleflashEntity flash = new MuzzleflashEntity((Level)sevel, (Player)player);
            flash.m_6034_(spawnX, spawnY, spawnZ);
            sevel.m_7967_((Entity)flash);
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        lvl.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.SUPER_NAILGUN_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void handleNailgunShoot(ServerPlayer player) {
        ServerLevel sevel = player.m_284548_();
        Level lvl = player.m_9236_();
        boolean rightSide = NailgunItem.rightSide;
        double offset = rightSide ? 0.3 : -0.3;
        double forwardOffset = 0.4;
        Vec3 look = player.m_20154_();
        Vec3 right = look.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        double spawnX = player.m_20185_() + right.f_82479_ * offset + look.f_82479_ * forwardOffset;
        double spawnY = player.m_20188_() - 0.1 + right.f_82480_ * offset + look.f_82480_ * forwardOffset;
        double spawnZ = player.m_20189_() + right.f_82481_ * offset + look.f_82481_ * forwardOffset;
        NailProjectileEntity nail = new NailProjectileEntity((EntityType<? extends Projectile>)((EntityType)ModEntities.NAIL_PROJECTILE.get()), (Level)sevel);
        ServerPlayHandler.shootFromRotationNoMomentum(nail, player, player.m_146909_(), player.m_146908_(), 1.0f, 0.0f);
        nail.m_6034_(spawnX, spawnY, spawnZ);
        sevel.m_7967_((Entity)nail);
        if (ServerPlayHandler.isMuzzleFlashEnabled()) {
            MuzzleflashEntity flash = new MuzzleflashEntity((Level)sevel, (Player)player);
            flash.m_6034_(spawnX, spawnY, spawnZ);
            sevel.m_7967_((Entity)flash);
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        lvl.m_6263_(null, posX, posY, posZ, (SoundEvent)ModSounds.NAILGUN_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void playAmmoEmptySound(ServerPlayer player) {
        Level level = player.m_9236_();
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11797_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

