/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.gastropodgalore.client.model.Modelapple_snail;
import net.mcreator.gastropodgalore.client.model.animations.apple_snailAnimation;
import net.mcreator.gastropodgalore.entity.AppleSnailEntity;
import net.mcreator.gastropodgalore.procedures.AppleSnailDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.MysterySnailDisplayConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AppleSnailRenderer
extends MobRenderer<AppleSnailEntity, LivingEntityRenderState, Modelapple_snail> {
    private AppleSnailEntity entity = null;

    public AppleSnailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelapple_snail.LAYER_LOCATION)), 0.1f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelapple_snail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/apple_snail.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = AppleSnailRenderer.this.entity.level();
                double x = AppleSnailRenderer.this.entity.getX();
                double y = AppleSnailRenderer.this.entity.getY();
                double z = AppleSnailRenderer.this.entity.getZ();
                if (AppleSnailDisplayConditionProcedure.execute((Entity)AppleSnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelapple_snail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelapple_snail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/mystery_snail.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = AppleSnailRenderer.this.entity.level();
                double x = AppleSnailRenderer.this.entity.getX();
                double y = AppleSnailRenderer.this.entity.getY();
                double z = AppleSnailRenderer.this.entity.getZ();
                if (MysterySnailDisplayConditionProcedure.execute((Entity)AppleSnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelapple_snail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(AppleSnailEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("gastropod_galore:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"gastropod_galore:textures/entities/apple_snail.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(0.85f, 0.85f, 0.85f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelapple_snail {
        private AppleSnailEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = apple_snailAnimation.actualidle.bake(root);
            this.keyframeAnimation1 = apple_snailAnimation.idle.bake(root);
            this.keyframeAnimation2 = apple_snailAnimation.hide.bake(root);
            this.keyframeAnimation3 = apple_snailAnimation.opening.bake(root);
        }

        public void setEntity(AppleSnailEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

