/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.gastropodgalore.client.model.Modelsnail;
import net.mcreator.gastropodgalore.client.model.animations.snailAnimation;
import net.mcreator.gastropodgalore.entity.ImmortalSnailEntity;
import net.mcreator.gastropodgalore.procedures.ImmortalSnailDisplayCondition1Procedure;
import net.mcreator.gastropodgalore.procedures.ImmortalSnailDisplayConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ImmortalSnailRenderer
extends MobRenderer<ImmortalSnailEntity, LivingEntityRenderState, Modelsnail> {
    private ImmortalSnailEntity entity = null;

    public ImmortalSnailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelsnail.LAYER_LOCATION)), 0.1f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = ImmortalSnailRenderer.this.entity.level();
                double x = ImmortalSnailRenderer.this.entity.getX();
                double y = ImmortalSnailRenderer.this.entity.getY();
                double z = ImmortalSnailRenderer.this.entity.getZ();
                if (ImmortalSnailDisplayConditionProcedure.execute((Entity)ImmortalSnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/immortal_snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = ImmortalSnailRenderer.this.entity.level();
                double x = ImmortalSnailRenderer.this.entity.getX();
                double y = ImmortalSnailRenderer.this.entity.getY();
                double z = ImmortalSnailRenderer.this.entity.getZ();
                if (ImmortalSnailDisplayCondition1Procedure.execute((Entity)ImmortalSnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(ImmortalSnailEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("gastropod_galore:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"gastropod_galore:textures/entities/snail_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(1.15f, 1.15f, 1.15f);
    }

    private static final class AnimatedModel
    extends Modelsnail {
        private ImmortalSnailEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = snailAnimation.actualidle.bake(root);
            this.keyframeAnimation1 = snailAnimation.idle.bake(root);
        }

        public void setEntity(ImmortalSnailEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

