/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.gastropodgalore.client.model.Modelvolcano_snail;
import net.mcreator.gastropodgalore.client.model.animations.volcano_snailAnimation;
import net.mcreator.gastropodgalore.entity.MagmaSnailEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MagmaSnailRenderer
extends MobRenderer<MagmaSnailEntity, LivingEntityRenderState, Modelvolcano_snail> {
    private MagmaSnailEntity entity = null;

    public MagmaSnailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelvolcano_snail.LAYER_LOCATION)), 0.3f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelvolcano_snail>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/volcano_snail.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelvolcano_snail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(MagmaSnailEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("gastropod_galore:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"gastropod_galore:textures/entities/volcano_snail.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(0.9f, 0.9f, 0.9f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelvolcano_snail {
        private MagmaSnailEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = volcano_snailAnimation.idle.bake(root);
            this.keyframeAnimation1 = volcano_snailAnimation.walk.bake(root);
            this.keyframeAnimation2 = volcano_snailAnimation.hide.bake(root);
            this.keyframeAnimation3 = volcano_snailAnimation.opening.bake(root);
        }

        public void setEntity(MagmaSnailEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

