/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.gastropodgalore.client.model.Modelslug;
import net.mcreator.gastropodgalore.client.model.animations.slugAnimation;
import net.mcreator.gastropodgalore.entity.SlugEntity;
import net.mcreator.gastropodgalore.procedures.BlackSlugDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.BrownSlugDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.RedSlugDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.TanSlugDisplayConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SlugRenderer
extends MobRenderer<SlugEntity, LivingEntityRenderState, Modelslug> {
    private SlugEntity entity = null;

    public SlugRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelslug.LAYER_LOCATION)), 0.1f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelslug>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/slug_tan.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SlugRenderer.this.entity.level();
                double x = SlugRenderer.this.entity.getX();
                double y = SlugRenderer.this.entity.getY();
                double z = SlugRenderer.this.entity.getZ();
                if (TanSlugDisplayConditionProcedure.execute((Entity)SlugRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelslug)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelslug>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/slug_red.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SlugRenderer.this.entity.level();
                double x = SlugRenderer.this.entity.getX();
                double y = SlugRenderer.this.entity.getY();
                double z = SlugRenderer.this.entity.getZ();
                if (BrownSlugDisplayConditionProcedure.execute((Entity)SlugRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelslug)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelslug>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/slug_black.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SlugRenderer.this.entity.level();
                double x = SlugRenderer.this.entity.getX();
                double y = SlugRenderer.this.entity.getY();
                double z = SlugRenderer.this.entity.getZ();
                if (BlackSlugDisplayConditionProcedure.execute((Entity)SlugRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelslug)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelslug>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/slug_green.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SlugRenderer.this.entity.level();
                double x = SlugRenderer.this.entity.getX();
                double y = SlugRenderer.this.entity.getY();
                double z = SlugRenderer.this.entity.getZ();
                if (RedSlugDisplayConditionProcedure.execute((Entity)SlugRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelslug)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SlugEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("gastropod_galore:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"gastropod_galore:textures/entities/slug_tan.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(1.15f, 1.15f, 1.15f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelslug {
        private SlugEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = slugAnimation.actualidle.bake(root);
            this.keyframeAnimation1 = slugAnimation.idle.bake(root);
        }

        public void setEntity(SlugEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

