/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.gastropodgalore.client.model.Modelsnail;
import net.mcreator.gastropodgalore.client.model.animations.snailAnimation;
import net.mcreator.gastropodgalore.entity.SnailEntity;
import net.mcreator.gastropodgalore.procedures.BrownSnailDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.GarySnailDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.GreenSnailDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.RedSnailDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.TankySnailDisplayConditionProcedure;
import net.mcreator.gastropodgalore.procedures.YellowSnailDisplayConditionProcedure;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SnailRenderer
extends MobRenderer<SnailEntity, LivingEntityRenderState, Modelsnail> {
    private SnailEntity entity = null;

    public SnailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelsnail.LAYER_LOCATION)), 0.1f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SnailRenderer.this.entity.level();
                double x = SnailRenderer.this.entity.getX();
                double y = SnailRenderer.this.entity.getY();
                double z = SnailRenderer.this.entity.getZ();
                if (BrownSnailDisplayConditionProcedure.execute((Entity)SnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/green_snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SnailRenderer.this.entity.level();
                double x = SnailRenderer.this.entity.getX();
                double y = SnailRenderer.this.entity.getY();
                double z = SnailRenderer.this.entity.getZ();
                if (GreenSnailDisplayConditionProcedure.execute((Entity)SnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/yellow_snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SnailRenderer.this.entity.level();
                double x = SnailRenderer.this.entity.getX();
                double y = SnailRenderer.this.entity.getY();
                double z = SnailRenderer.this.entity.getZ();
                if (YellowSnailDisplayConditionProcedure.execute((Entity)SnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/reddish_snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SnailRenderer.this.entity.level();
                double x = SnailRenderer.this.entity.getX();
                double y = SnailRenderer.this.entity.getY();
                double z = SnailRenderer.this.entity.getZ();
                if (RedSnailDisplayConditionProcedure.execute((Entity)SnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/tanky_snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SnailRenderer.this.entity.level();
                double x = SnailRenderer.this.entity.getX();
                double y = SnailRenderer.this.entity.getY();
                double z = SnailRenderer.this.entity.getZ();
                if (TankySnailDisplayConditionProcedure.execute((Entity)SnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelsnail>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"gastropod_galore:textures/entities/gary_snail_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = SnailRenderer.this.entity.level();
                double x = SnailRenderer.this.entity.getX();
                double y = SnailRenderer.this.entity.getY();
                double z = SnailRenderer.this.entity.getZ();
                if (GarySnailDisplayConditionProcedure.execute((Entity)SnailRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelsnail)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SnailEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("gastropod_galore:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"gastropod_galore:textures/entities/snail_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(1.15f, 1.15f, 1.15f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelsnail {
        private SnailEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;
        private final KeyframeAnimation keyframeAnimation2;
        private final KeyframeAnimation keyframeAnimation3;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = snailAnimation.actualidle.bake(root);
            this.keyframeAnimation1 = snailAnimation.hide.bake(root);
            this.keyframeAnimation2 = snailAnimation.opening.bake(root);
            this.keyframeAnimation3 = snailAnimation.idle.bake(root);
        }

        public void setEntity(SnailEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            this.keyframeAnimation2.apply(this.entity.animationState2, state.ageInTicks, 1.0f);
            this.keyframeAnimation3.apply(this.entity.animationState3, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

