/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.gastropodgalore.init.GastropodGaloreModEntities;
import net.mcreator.gastropodgalore.procedures.FarmingGastropodNaturalEntitySpawningConditionProcedure;
import net.mcreator.gastropodgalore.procedures.HidingSnailPlaybackConditionProcedure;
import net.mcreator.gastropodgalore.procedures.IdleSnailPlaybackConditionProcedure;
import net.mcreator.gastropodgalore.procedures.OpeningSnailPlaybackConditionProcedure;
import net.mcreator.gastropodgalore.procedures.SnailEntityIsHurtProcedure;
import net.mcreator.gastropodgalore.procedures.SnailOnEntityTickUpdateProcedure;
import net.mcreator.gastropodgalore.procedures.SnailOnInitialEntitySpawnProcedure;
import net.mcreator.gastropodgalore.procedures.SnailRightclickedOnEntityProcedure;
import net.mcreator.gastropodgalore.procedures.WalkSnailPlaybackConditionProcedure;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class SnailEntity
extends TamableAnimal {
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_variant = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hide = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_eat_timer = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hide_timer = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_breed_cooldown = SynchedEntityData.defineId(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public SnailEntity(EntityType<SnailEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE, (Object)"snail_texture");
        builder.define(DATA_variant, (Object)0);
        builder.define(DATA_hide, (Object)0);
        builder.define(DATA_eat_timer, (Object)0);
        builder.define(DATA_hide_timer, (Object)0);
        builder.define(DATA_breed_cooldown, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Frog.class, 10.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.WHEAT), false));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.BEETROOT), false));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.POTATO), false));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.CARROT), false));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.CARROT), false));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"gastropod_galore:snail_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"gastropod_galore:snail_dies"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SnailEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        SnailEntityIsHurtProcedure.execute((Entity)entity);
        return super.hurtServer(level, damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        SnailOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putString("Texture", this.getTexture());
        valueOutput.putInt("Datavariant", ((Integer)this.entityData.get(DATA_variant)).intValue());
        valueOutput.putInt("Datahide", ((Integer)this.entityData.get(DATA_hide)).intValue());
        valueOutput.putInt("Dataeat_timer", ((Integer)this.entityData.get(DATA_eat_timer)).intValue());
        valueOutput.putInt("Datahide_timer", ((Integer)this.entityData.get(DATA_hide_timer)).intValue());
        valueOutput.putInt("Databreed_cooldown", ((Integer)this.entityData.get(DATA_breed_cooldown)).intValue());
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setTexture(valueInput.getStringOr("Texture", "snail_texture"));
        this.entityData.set(DATA_variant, (Object)valueInput.getIntOr("Datavariant", 0));
        this.entityData.set(DATA_hide, (Object)valueInput.getIntOr("Datahide", 0));
        this.entityData.set(DATA_eat_timer, (Object)valueInput.getIntOr("Dataeat_timer", 0));
        this.entityData.set(DATA_hide_timer, (Object)valueInput.getIntOr("Datahide_timer", 0));
        this.entityData.set(DATA_breed_cooldown, (Object)valueInput.getIntOr("Databreed_cooldown", 0));
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        SnailEntity entity = this;
        Level world = this.level();
        SnailRightclickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdleSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(HidingSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(OpeningSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(WalkSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        SnailOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        SnailEntity retval = (SnailEntity)((EntityType)GastropodGaloreModEntities.SNAIL.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((HolderSet)HolderSet.emptyNamed((HolderOwner)BuiltInRegistries.ITEM, (TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"gastropod_galore:calcium")))).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)GastropodGaloreModEntities.SNAIL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return FarmingGastropodNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.1);
        builder = builder.add(Attributes.MAX_HEALTH, 8.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

