/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.entity;

import java.util.function.Predicate;
import net.mcreator.gastropodgalore.entity.LavaGoopEntity;
import net.mcreator.gastropodgalore.init.GastropodGaloreModEntities;
import net.mcreator.gastropodgalore.procedures.HidingVolcanicSnailPlaybackConditionProcedure;
import net.mcreator.gastropodgalore.procedures.IdleVolcanicSnailPlaybackConditionProcedure;
import net.mcreator.gastropodgalore.procedures.OpeningVolcanicSnailPlaybackConditionProcedure;
import net.mcreator.gastropodgalore.procedures.VolcanicSnailOnEntityTickUpdateProcedure;
import net.mcreator.gastropodgalore.procedures.WalkSnailPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class VolcanicSnailEntity
extends Animal
implements RangedAttackMob {
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(VolcanicSnailEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_hide = SynchedEntityData.defineId(VolcanicSnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_lava_cracks = SynchedEntityData.defineId(VolcanicSnailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public VolcanicSnailEntity(EntityType<VolcanicSnailEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE, (Object)"volcano_snail");
        builder.define(DATA_hide, (Object)0);
        builder.define(DATA_lava_cracks, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, MagmaCube.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, true, false));
        this.targetSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike)Items.MAGMA_CREAM), false));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 10.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"gastropod_galore:volcanic_snail_rumbles"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"gastropod_galore:volcanic_snail_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"gastropod_galore:volcanic_snail_dies"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putString("Texture", this.getTexture());
        valueOutput.putInt("Datahide", ((Integer)this.entityData.get(DATA_hide)).intValue());
        valueOutput.putInt("Datalava_cracks", ((Integer)this.entityData.get(DATA_lava_cracks)).intValue());
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setTexture(valueInput.getStringOr("Texture", "volcano_snail"));
        this.entityData.set(DATA_hide, (Object)valueInput.getIntOr("Datahide", 0));
        this.entityData.set(DATA_lava_cracks, (Object)valueInput.getIntOr("Datalava_cracks", 0));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdleVolcanicSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(WalkSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(HidingVolcanicSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(OpeningVolcanicSnailPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        VolcanicSnailOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        LavaGoopEntity.shoot((LivingEntity)this, target);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        VolcanicSnailEntity retval = (VolcanicSnailEntity)((EntityType)GastropodGaloreModEntities.VOLCANIC_SNAIL.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike)Items.MAGMA_CREAM).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)GastropodGaloreModEntities.VOLCANIC_SNAIL.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.1);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

