/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gastropodgalore.procedures;

import java.util.Comparator;
import net.mcreator.gastropodgalore.entity.ImmortalSnailEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmortalSnailOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!world.isClientSide()) {
            Entity _ent;
            LivingEntity _entity;
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 9999, 255, false, false));
            }
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 9999, 255, false, false));
            }
            if (entity.getPersistentData().getDoubleOr("invert", 0.0) >= 200.0) {
                ImmortalSnailEntity _datEntSetI;
                if (entity instanceof ImmortalSnailEntity) {
                    _datEntSetI = (ImmortalSnailEntity)entity;
                    _datEntSetI.getEntityData().set(ImmortalSnailEntity.DATA_variant, (Object)1);
                }
                if (entity.getPersistentData().getDoubleOr("invert2", 0.0) >= 10.0) {
                    if (entity instanceof ImmortalSnailEntity) {
                        _datEntSetI = (ImmortalSnailEntity)entity;
                        _datEntSetI.getEntityData().set(ImmortalSnailEntity.DATA_variant, (Object)0);
                    }
                } else {
                    entity.getPersistentData().putDouble("invert2", entity.getPersistentData().getDoubleOr("invert2", 0.0) + 1.0);
                }
            } else {
                entity.getPersistentData().putDouble("invert", entity.getPersistentData().getDoubleOr("invert", 0.0) + 1.0);
            }
            Vec3 _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(1.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                if (!(entityiterator instanceof Player) && !(entityiterator instanceof ServerPlayer)) continue;
                if (entityiterator instanceof Player) {
                    Player _plr = (Player)entityiterator;
                    if (_plr.getAbilities().instabuild) {
                        _ent = entityiterator;
                        if (_ent.level().isClientSide() || _ent.getServer() == null) continue;
                        _ent.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, _ent.position(), _ent.getRotationVector(), _ent.level() instanceof ServerLevel ? (ServerLevel)_ent.level() : null, 4, _ent.getName().getString(), _ent.getDisplayName(), _ent.level().getServer(), _ent), "kill @s");
                        continue;
                    }
                }
                if (ImmortalSnailOnEntityTickUpdateProcedure.getEntityGameType(entityiterator) == GameType.SPECTATOR) {
                    _ent = entityiterator;
                    if (_ent.level().isClientSide() || _ent.getServer() == null) continue;
                    _ent.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, _ent.position(), _ent.getRotationVector(), _ent.level() instanceof ServerLevel ? (ServerLevel)_ent.level() : null, 4, _ent.getName().getString(), _ent.getDisplayName(), _ent.level().getServer(), _ent), "kill @s");
                    continue;
                }
                entityiterator.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"gastropod_galore:immortal_snail_damage"))), entity), 99999.0f);
            }
            _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(5000.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                if (!(entityiterator instanceof Player) && !(entityiterator instanceof ServerPlayer) || !(entity instanceof Mob)) continue;
                Mob _entity2 = (Mob)entity;
                if (!(entityiterator instanceof LivingEntity)) continue;
                _ent = (LivingEntity)entityiterator;
                _entity2.setTarget((LivingEntity)_ent);
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

