/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.stirdrem.overgeared.compat.ForgingRecipeCategory;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.screen.AbstractSmithingAnvilMenu;
import org.jetbrains.annotations.Nullable;

public class ForgingRecipeTransferHandler
implements IRecipeTransferHandler<AbstractSmithingAnvilMenu, ForgingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final MenuType<? extends AbstractSmithingAnvilMenu> menuType;

    public ForgingRecipeTransferHandler(IRecipeTransferHandlerHelper helper, MenuType<? extends AbstractSmithingAnvilMenu> menuType) {
        this.handlerHelper = helper;
        this.menuType = menuType;
    }

    public Class<AbstractSmithingAnvilMenu> getContainerClass() {
        return AbstractSmithingAnvilMenu.class;
    }

    public Optional<MenuType<AbstractSmithingAnvilMenu>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public RecipeType<ForgingRecipe> getRecipeType() {
        return ForgingRecipeCategory.FORGING_RECIPE_TYPE;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(AbstractSmithingAnvilMenu container, ForgingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        if (player.m_9236_().m_5776_()) {
            return null;
        }
        List<Integer> inputSlots = container.getInputSlots();
        if (inputSlots == null || inputSlots.isEmpty()) {
            return this.handlerHelper.createInternalError();
        }
        ArrayList ingredients = new ArrayList();
        recipe.m_7527_().forEach(ing -> {
            ItemStack[] matching = ing.m_43908_();
            if (matching.length > 0) {
                ingredients.add(matching[0]);
            } else {
                ingredients.add(ItemStack.f_41583_);
            }
        });
        if (ingredients.size() > inputSlots.size()) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.m_237113_((String)"Not enough input slots for this recipe!"));
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            boolean moved;
            int slotIndex;
            ItemStack slotStack;
            ItemStack needed = (ItemStack)ingredients.get(i);
            if (needed.m_41619_() || !(slotStack = container.m_38853_(slotIndex = inputSlots.get(i).intValue()).m_7993_()).m_41619_() && ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)needed) || (moved = this.moveItemFromPlayerInventory(player, needed, container, slotIndex))) continue;
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.m_237113_((String)("Missing required item: " + needed.m_41786_().getString())));
        }
        return null;
    }

    private boolean moveItemFromPlayerInventory(Player player, ItemStack needed, AbstractSmithingAnvilMenu container, int targetSlot) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)invStack, (ItemStack)needed) || invStack.m_41613_() < needed.m_41613_()) continue;
            ItemStack toMove = invStack.m_41777_();
            toMove.m_41764_(needed.m_41613_());
            container.m_38853_(targetSlot).m_5852_(toMove);
            invStack.m_41774_(needed.m_41613_());
            return true;
        }
        return false;
    }
}

