/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.mixin;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.util.ModTags;
import net.stirdrem.overgeared.util.QualityHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    private static final Map<UUID, Long> lastTongsHit = new WeakHashMap<UUID, Long>();
    private static final String HEATED_TIME_TAG = "HeatedSince";
    private static final String HEATED_TAG = "Heated";

    @Inject(method={"getDestroySpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyMiningSpeed(BlockState state, CallbackInfoReturnable<Float> cir) {
        ItemStack stack = (ItemStack)this;
        float baseSpeed = cir.getReturnValueF();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            float multiplier = QualityHelper.getQualityMultiplier(stack);
            cir.setReturnValue((Object)Float.valueOf(baseSpeed * multiplier));
        }
    }

    @Inject(method={"getMaxDamage()I"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyDurabilityBasedOnQuality(CallbackInfoReturnable<Integer> cir) {
        int newBaseDurability;
        ItemStack stack = (ItemStack)this;
        if (!stack.m_41763_()) {
            return;
        }
        int originalDurability = (Integer)cir.getReturnValue();
        boolean blacklisted = OvergearedMod.isDurabilityMultiplierBlacklisted(stack);
        float baseMultiplier = ((Double)ServerConfig.BASE_DURABILITY_MULTIPLIER.get()).floatValue();
        int n = newBaseDurability = blacklisted ? originalDurability : (int)((float)originalDurability * baseMultiplier);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            float multiplier = QualityHelper.getQualityMultiplier(stack);
            newBaseDurability = (int)((float)newBaseDurability * multiplier);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ReducedMaxDurability")) {
            int reductions = stack.m_41783_().m_128451_("ReducedMaxDurability");
            float durabilityPenaltyMultiplier = 1.0f - (float)reductions * ((Double)ServerConfig.DURABILITY_REDUCE_PER_GRIND.get()).floatValue();
            durabilityPenaltyMultiplier = Math.max(0.1f, durabilityPenaltyMultiplier);
            newBaseDurability = (int)((float)newBaseDurability * durabilityPenaltyMultiplier);
        }
        cir.setReturnValue((Object)newBaseDurability);
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    private void onInventoryTick(Level level, Entity entity, int slot, boolean selected, CallbackInfo ci) {
        boolean hasHotItem;
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        long tick = level.m_46467_();
        int cooldownTicks = (Integer)ServerConfig.HEATED_ITEM_COOLDOWN_TICKS.get();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item cooled;
            if (stack.m_41619_() || !stack.m_204117_(ModTags.Items.HEATED_METALS)) continue;
            CompoundTag tag = stack.m_41784_();
            long heatedSince = tag.m_128454_(HEATED_TIME_TAG);
            if (heatedSince == 0L) {
                tag.m_128356_(HEATED_TIME_TAG, tick);
                continue;
            }
            if (tick - heatedSince < (long)cooldownTicks || (cooled = OvergearedMod.getCooledIngot(stack.m_41720_(), level)) == null) continue;
            ItemStack newStack = new ItemStack((ItemLike)cooled, stack.m_41613_());
            boolean isMain = stack == player.m_21205_();
            boolean isOff = stack == player.m_21206_();
            stack.m_41764_(0);
            if (isMain) {
                player.m_21008_(InteractionHand.MAIN_HAND, newStack);
            } else if (isOff) {
                player.m_21008_(InteractionHand.OFF_HAND, newStack);
            } else if (!player.m_150109_().m_36054_(newStack)) {
                player.m_36176_(newStack, false);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.7f, 1.0f);
        }
        boolean bl = hasHotItem = player.m_150109_().f_35974_.stream().anyMatch(s -> !s.m_41619_() && (s.m_204117_(ModTags.Items.HEATED_METALS) || s.m_204117_(ModTags.Items.HOT_ITEMS)) || s.m_41782_() && s.m_41783_().m_128441_(HEATED_TAG)) || player.m_21205_().m_204117_(ModTags.Items.HEATED_METALS) || player.m_21205_().m_204117_(ModTags.Items.HOT_ITEMS) || player.m_21206_().m_204117_(ModTags.Items.HEATED_METALS) || player.m_21206_().m_204117_(ModTags.Items.HOT_ITEMS);
        if (!hasHotItem) {
            return;
        }
        UUID uuid = player.m_20148_();
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        ItemStack tongsStack = !main.m_41619_() && main.m_41720_().m_204114_().m_203656_(ModTags.Items.TONGS) ? main : (!off.m_41619_() && off.m_41720_().m_204114_().m_203656_(ModTags.Items.TONGS) ? off : ItemStack.f_41583_);
        if (!tongsStack.m_41619_()) {
            if (tick % 40L != 0L) {
                return;
            }
            long last = lastTongsHit.getOrDefault(uuid, -1L);
            if (last != tick) {
                tongsStack.m_41622_(1, (LivingEntity)player, p -> {
                    InteractionHand hand = tongsStack == player.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    p.m_21190_(hand);
                });
                lastTongsHit.put(uuid, tick);
            }
        } else if (!player.m_21023_(MobEffects.f_19607_)) {
            player.m_6469_(player.m_269291_().m_269047_(), 1.0f);
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixDurabilityBar(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        if (!stack.m_41763_()) {
            return;
        }
        int maxDamage = stack.m_41776_();
        int damage = stack.m_41773_();
        if (damage >= maxDamage) {
            cir.setReturnValue((Object)0);
            return;
        }
        int width = Math.round(13.0f - (float)damage * 13.0f / (float)maxDamage);
        cir.setReturnValue((Object)width);
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void fixDurabilityBarColor(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        if (!stack.m_41763_()) {
            return;
        }
        int max = stack.m_41776_();
        int damage = stack.m_41773_();
        if (max <= 0) {
            cir.setReturnValue((Object)0xFFFFFF);
            return;
        }
        float ratio = Math.max(0.0f, 1.0f - (float)damage / (float)max);
        float hue = ratio / 3.0f;
        int color = Mth.m_14169_((float)hue, (float)1.0f, (float)1.0f);
        cir.setReturnValue((Object)color);
    }
}

