/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.util;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.recipe.ItemToToolTypeRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;

public class CastingConfigHelper {
    public static String getToolTypeDisplayName(String toolType) {
        return "tooltype.overgeared." + toolType.toLowerCase();
    }

    public static int getMaxMaterialAmount(String toolType) {
        for (List e : (List)ServerConfig.CASTING_TOOL_TYPES.get()) {
            List row = e;
            if (!row.get(0).equals(toolType)) continue;
            return ((Number)row.get(1)).intValue();
        }
        return 0;
    }

    public static String getMaterialDisplayName(String materialId) {
        return "material.overgeared." + materialId.toLowerCase();
    }

    public static String getToolTypeForItem(Level level, ItemStack stack) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.ITEM_TO_TOOLTYPE.get()).stream().filter(r -> r.getInput().test(stack)).map(ItemToToolTypeRecipe::getToolType).findFirst().orElse("none");
    }

    public static String getMaterialForItem(ItemStack stack) {
        return CastingConfigHelper.getMaterialForItem(stack.m_41720_());
    }

    public static String getMaterialForItem(Item item) {
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!CastingConfigHelper.matchesItemOrTag(item, key)) continue;
            return (String)row.get(1);
        }
        return "none";
    }

    public static int getMaterialValue(ItemStack stack) {
        return CastingConfigHelper.getMaterialValue(stack.m_41720_());
    }

    public static int getMaterialValue(Item item) {
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!CastingConfigHelper.matchesItemOrTag(item, key)) continue;
            return ((Number)row.get(2)).intValue();
        }
        return 0;
    }

    public static boolean isValidMaterial(ItemStack stack) {
        return CastingConfigHelper.isValidMaterial(stack.m_41720_());
    }

    public static boolean isValidMaterial(Item item) {
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!CastingConfigHelper.matchesItemOrTag(item, key)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesItemOrTag(Item item, String key) {
        if (BuiltInRegistries.f_257033_.m_7981_((Object)item).toString().equals(key)) {
            return true;
        }
        if (key.startsWith("#")) {
            String tagId = key.substring(1);
            TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
            return item.m_204114_().m_203656_(tag);
        }
        return false;
    }
}

