/*
 * Decompiled with CFR 0.152.
 */
package de.dragonixmc.potionrestock.client.logic;

import de.dragonixmc.potionrestock.PotionRestockMod;
import de.dragonixmc.potionrestock.client.PotionRestockClient;
import de.dragonixmc.potionrestock.client.logic.PotionDescriptor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class PotionRestockLogic {
    private static final int MAX_PENDING_ACTIONS = 4;
    private static final int MAX_WAIT_FOR_MATCH_TICKS = 80;
    private static final int DROP_SETTLE_TICKS = 8;
    private static final int MAX_ACTIVE_WAIT_TICKS = 40;
    private static final PotionRestockLogic INSTANCE = new PotionRestockLogic();
    private final Deque<PendingRestock> pendingActions = new ArrayDeque<PendingRestock>();
    private ActivePotionUse activeUse;

    private PotionRestockLogic() {
    }

    public static PotionRestockLogic get() {
        return INSTANCE;
    }

    public void tick(class_310 client) {
        class_746 player = client.field_1724;
        class_636 interaction = client.field_1761;
        if (player == null || interaction == null) {
            this.pendingActions.clear();
            this.activeUse = null;
            return;
        }
        if (!PotionRestockClient.getConfig().automationEnabled || player.method_68878() || player.method_7325()) {
            this.pendingActions.clear();
            this.activeUse = null;
            return;
        }
        this.handleActivePotionUse(player);
        Iterator<PendingRestock> iterator = this.pendingActions.iterator();
        while (iterator.hasNext()) {
            PendingRestock action = iterator.next();
            if (!action.isFor(player)) {
                iterator.remove();
                continue;
            }
            action.incrementAge();
            if (!action.hasDroppedBottle()) {
                if (action.requiresBottleDrop()) {
                    boolean dropped = this.tryDropBottle(player, interaction, action);
                    if (dropped) {
                        action.markBottleDropped();
                        continue;
                    }
                    if (!action.exceededDropWindow()) continue;
                    iterator.remove();
                    continue;
                }
                action.markBottleDropped();
                continue;
            }
            action.incrementPostDropTicks();
            if (!action.readyForRestock() || !this.isHotbarSlotEmpty(player, action.hotbarSlot())) continue;
            OptionalInt restockSlot = this.findRestockSlot(player.method_31548(), action.descriptor(), action.hotbarSlot());
            if (restockSlot.isEmpty()) {
                if (action.ticksAlive() <= 80) continue;
                PotionRestockMod.LOGGER.debug("No replacement potion found for slot {}", (Object)action.hotbarSlot());
                iterator.remove();
                continue;
            }
            boolean swapped = this.swapIntoHotbar(player, interaction, restockSlot.getAsInt(), action.hotbarSlot());
            if (!swapped) continue;
            iterator.remove();
        }
    }

    private void handleActivePotionUse(class_746 player) {
        boolean finished;
        boolean usingPotion;
        boolean bl = usingPotion = player.method_6115() && player.method_6058() == class_1268.field_5808 && player.method_6030().method_31574(class_1802.field_8574);
        if (usingPotion) {
            int slot = player.method_31548().method_67532();
            if (this.activeUse == null) {
                class_1799 snapshot = player.method_6030().method_7972();
                snapshot.method_7939(1);
                this.activeUse = new ActivePotionUse(slot, PotionDescriptor.from(snapshot), player.method_6030().method_31574(class_1802.field_8574));
            } else {
                this.activeUse.updateHotbarSlot(slot);
                this.activeUse.resetWait();
            }
            return;
        }
        if (this.activeUse == null) {
            return;
        }
        this.activeUse.startWaiting();
        class_1661 inventory = player.method_31548();
        class_1799 stack = inventory.method_5438(this.activeUse.hotbarSlot());
        boolean bl2 = finished = this.activeUse.requiresBottleDrop() ? stack.method_31574(class_1802.field_8469) : stack.method_7960();
        if (finished) {
            this.enqueueRestock(player, this.activeUse.descriptor(), this.activeUse.hotbarSlot(), this.activeUse.requiresBottleDrop());
            this.activeUse = null;
            return;
        }
        this.activeUse.incrementWait();
        if (this.activeUse.waitTicks() > 40) {
            this.activeUse = null;
        }
    }

    public void onThrowablePotionUse(class_746 player, class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8436) && !stack.method_31574(class_1802.field_8150)) {
            return;
        }
        class_1799 snapshot = stack.method_7972();
        snapshot.method_7939(1);
        this.activeUse = new ActivePotionUse(player.method_31548().method_67532(), PotionDescriptor.from(snapshot), false);
    }

    private void enqueueRestock(class_746 player, PotionDescriptor descriptor, int slot, boolean requiresBottleDrop) {
        this.pendingActions.addLast(new PendingRestock(player.method_5667(), slot, descriptor, requiresBottleDrop));
        while (this.pendingActions.size() > 4) {
            this.pendingActions.removeFirst();
        }
    }

    private boolean tryDropBottle(class_746 player, class_636 interaction, PendingRestock action) {
        class_1661 inventory = player.method_31548();
        class_1799 stack = inventory.method_5438(action.hotbarSlot());
        if (!stack.method_31574(class_1802.field_8469)) {
            return false;
        }
        int handlerSlot = this.findHandlerSlot(player, inventory, action.hotbarSlot());
        if (handlerSlot == -1) {
            return false;
        }
        interaction.method_2906(player.field_7498.field_7763, handlerSlot, 0, class_1713.field_7795, (class_1657)player);
        return true;
    }

    private boolean isHotbarSlotEmpty(class_746 player, int slot) {
        return player.method_31548().method_5438(slot).method_7960();
    }

    private OptionalInt findRestockSlot(class_1661 inventory, PotionDescriptor descriptor, int hotbarSlot) {
        class_1799 candidate;
        int slot;
        for (slot = 9; slot < 36; ++slot) {
            candidate = inventory.method_5438(slot);
            if (candidate.method_7960() || !descriptor.matchesExact(candidate)) continue;
            return OptionalInt.of(slot);
        }
        for (slot = 9; slot < 36; ++slot) {
            candidate = inventory.method_5438(slot);
            if (candidate.method_7960() || !descriptor.matchesByEffectTypes(candidate)) continue;
            return OptionalInt.of(slot);
        }
        return OptionalInt.empty();
    }

    private boolean swapIntoHotbar(class_746 player, class_636 interaction, int inventorySlot, int hotbarSlot) {
        if (inventorySlot < 9 || inventorySlot >= 36) {
            return false;
        }
        int handlerSlot = this.findHandlerSlot(player, player.method_31548(), inventorySlot);
        if (handlerSlot == -1) {
            return false;
        }
        interaction.method_2906(player.field_7498.field_7763, handlerSlot, hotbarSlot, class_1713.field_7791, (class_1657)player);
        return true;
    }

    private int findHandlerSlot(class_746 player, class_1661 inventory, int inventorySlot) {
        for (int handlerSlot = 0; handlerSlot < player.field_7498.field_7761.size(); ++handlerSlot) {
            class_1735 slot = (class_1735)player.field_7498.field_7761.get(handlerSlot);
            if (slot.field_7871 != inventory || slot.method_34266() != inventorySlot) continue;
            return handlerSlot;
        }
        return -1;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ActivePotionUse {
        private int hotbarSlot;
        private final PotionDescriptor descriptor;
        private final boolean requiresBottleDrop;
        private int waitTicks;
        private boolean waitingForBottle;

        private ActivePotionUse(int hotbarSlot, PotionDescriptor descriptor, boolean requiresBottleDrop) {
            this.hotbarSlot = hotbarSlot;
            this.descriptor = descriptor;
            this.requiresBottleDrop = requiresBottleDrop;
        }

        void updateHotbarSlot(int slot) {
            this.hotbarSlot = slot;
        }

        void resetWait() {
            this.waitTicks = 0;
            this.waitingForBottle = false;
        }

        void startWaiting() {
            if (!this.waitingForBottle) {
                this.waitingForBottle = true;
                this.waitTicks = 0;
            }
        }

        void incrementWait() {
            if (this.waitingForBottle) {
                ++this.waitTicks;
            }
        }

        int waitTicks() {
            return this.waitTicks;
        }

        int hotbarSlot() {
            return this.hotbarSlot;
        }

        PotionDescriptor descriptor() {
            return this.descriptor;
        }

        boolean requiresBottleDrop() {
            return this.requiresBottleDrop;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class PendingRestock {
        private static final int MAX_DROP_WAIT_TICKS = 20;
        private final UUID playerId;
        private final int hotbarSlot;
        private final PotionDescriptor descriptor;
        private final boolean requiresBottleDrop;
        private int ticksAlive;
        private boolean bottleDropped;
        private int postDropTicks;

        private PendingRestock(UUID playerId, int hotbarSlot, PotionDescriptor descriptor, boolean requiresBottleDrop) {
            this.playerId = playerId;
            this.hotbarSlot = hotbarSlot;
            this.descriptor = descriptor;
            this.requiresBottleDrop = requiresBottleDrop;
        }

        boolean isFor(class_746 player) {
            return player.method_5667().equals(this.playerId);
        }

        int hotbarSlot() {
            return this.hotbarSlot;
        }

        PotionDescriptor descriptor() {
            return this.descriptor;
        }

        void incrementAge() {
            ++this.ticksAlive;
        }

        int ticksAlive() {
            return this.ticksAlive;
        }

        boolean hasDroppedBottle() {
            return this.bottleDropped;
        }

        boolean requiresBottleDrop() {
            return this.requiresBottleDrop;
        }

        void markBottleDropped() {
            this.bottleDropped = true;
            this.postDropTicks = 0;
        }

        void incrementPostDropTicks() {
            if (this.bottleDropped) {
                ++this.postDropTicks;
            }
        }

        boolean readyForRestock() {
            return this.bottleDropped && this.postDropTicks >= 8;
        }

        boolean exceededDropWindow() {
            return !this.bottleDropped && this.ticksAlive > 20;
        }
    }
}

