/*
 * Decompiled with CFR 0.152.
 */
package de.dragonixmc.potionrestock.client.hud;

import de.dragonixmc.potionrestock.client.PotionRestockClient;
import de.dragonixmc.potionrestock.client.config.PotionRestockConfig;
import de.dragonixmc.potionrestock.client.logic.PotionDescriptor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public final class PotionHudOverlay {
    private static final Map<class_2960, Supplier<class_2561>> SINGLE_POTION_NOTES = PotionHudOverlay.createSingleNotes();
    private static final Map<class_2960, Supplier<class_2561>> MULTI_POTION_NOTES = PotionHudOverlay.createMultiNotes();
    private static final DecimalFormat ATTRIBUTE_FORMAT = new DecimalFormat("#.##");
    private boolean visible = true;

    public void toggle() {
        this.visible = !this.visible;
    }

    public void render(class_332 drawContext) {
        int activeEffects;
        int y;
        if (!this.visible) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842 || client.field_1724 == null) {
            return;
        }
        PotionRestockConfig config = PotionRestockClient.getConfig();
        if (!config.hudEnabled) {
            return;
        }
        List<HudEntry> entries = this.collectEntries(client.field_1724);
        if (entries.isEmpty()) {
            return;
        }
        PotionRestockConfig.HudPosition position = config.hudPosition == null ? PotionRestockConfig.HudPosition.BOTTOM_LEFT : config.hudPosition;
        boolean anchorLeft = position.anchorLeft();
        boolean anchorTop = position.anchorTop();
        int iconSize = 16;
        int entryHeight = iconSize + 4;
        int spacing = 6;
        boolean showDetails = client.field_1690.field_1907.method_1434();
        int offsetX = Math.max(0, config.hudOffsetX);
        int offsetY = Math.max(0, config.hudOffsetY);
        int totalHeight = entryHeight * entries.size();
        int iconX = anchorLeft ? offsetX : drawContext.method_51421() - offsetX - iconSize;
        int n = y = anchorTop ? offsetY : drawContext.method_51443() - offsetY - totalHeight;
        if (anchorTop && !anchorLeft && client.field_1724 != null && (activeEffects = client.field_1724.method_6026().size()) > 0) {
            int effectStackBottom = offsetY + activeEffects * 26 + 4;
            y = Math.max(y, effectStackBottom);
        }
        int labelColor = this.withOpacity(config.hudTextColor, config.hudOpacity);
        for (HudEntry entry : entries) {
            class_1799 sample = entry.sample().method_7972();
            drawContext.method_51427(sample, iconX, y);
            class_5250 countLabel = class_2561.method_43470((String)(entry.count() + "x"));
            int countWidth = client.field_1772.method_27525((class_5348)countLabel);
            Objects.requireNonNull(client.field_1772);
            int textY = y + (iconSize - 9) / 2;
            int countAnchor = anchorLeft ? iconX + iconSize + spacing : iconX - spacing;
            int countX = anchorLeft ? countAnchor : countAnchor - countWidth;
            this.drawTextOverlay(drawContext, client, (class_2561)countLabel, countX, textY, labelColor);
            if (showDetails) {
                List<class_2561> detailLines = this.buildEffectText(sample);
                int infoAnchor = anchorLeft ? countX + countWidth + spacing : countX - spacing;
                int infoY = y;
                for (class_2561 line : detailLines) {
                    int width = client.field_1772.method_27525((class_5348)line);
                    int infoX = anchorLeft ? infoAnchor : infoAnchor - width;
                    this.drawTextOverlay(drawContext, client, line, infoX, infoY, labelColor);
                    Objects.requireNonNull(client.field_1772);
                    infoY += 9 + 1;
                }
            }
            y += entryHeight;
        }
    }

    private List<HudEntry> collectEntries(class_746 player) {
        class_1661 inventory = player.method_31548();
        LinkedHashMap<PotionDescriptor, HudEntry> aggregates = new LinkedHashMap<PotionDescriptor, HudEntry>();
        for (int slot = 0; slot < 36; ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (!(stack.method_7909() instanceof class_1812)) continue;
            PotionDescriptor descriptor = PotionDescriptor.from(stack);
            int amount = stack.method_7947();
            aggregates.compute(descriptor, (key, entry) -> {
                if (entry == null) {
                    return new HudEntry(stack.method_7972(), amount);
                }
                return entry.incremented(amount);
            });
        }
        ArrayList<HudEntry> sorted = new ArrayList<HudEntry>(aggregates.values());
        sorted.sort(Comparator.comparing(entry -> entry.sample().method_7964().getString()));
        return sorted;
    }

    private List<class_2561> buildEffectText(class_1799 stack) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_1844 contents = PotionHudOverlay.contents(stack);
        class_2960 potionId = PotionHudOverlay.potionId(contents);
        ArrayList<class_1293> effectList = new ArrayList<class_1293>();
        for (class_1293 effect : contents.method_57397()) {
            effectList.add(effect);
        }
        if (effectList.isEmpty()) {
            lines.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
            return lines;
        }
        if (effectList.size() > 1) {
            lines.add(this.multiEffectHeading(stack, (class_1293)effectList.get(0)));
            class_2561 override = PotionHudOverlay.multiNoteFor(potionId);
            if (override != null) {
                lines.add(override);
            } else {
                lines.add(this.multiEffectLine(effectList));
            }
            return lines;
        }
        class_1293 primary = (class_1293)effectList.get(0);
        class_5250 heading = this.effectLabel(primary);
        if (!((class_1291)primary.method_5579().comp_349()).method_5561()) {
            heading = heading.method_10852((class_2561)class_2561.method_43470((String)(" (" + this.formatDuration(primary) + ")")));
        }
        lines.add((class_2561)heading);
        class_2561 special = PotionHudOverlay.singleNoteFor(potionId);
        if (special != null) {
            lines.add(special);
            return lines;
        }
        if (this.isEffect(primary, (class_6880<class_1291>)class_1294.field_5921)) {
            lines.add(this.instantDamageDescription(primary));
        } else if (this.isEffect(primary, (class_6880<class_1291>)class_1294.field_5924)) {
            lines.add(this.regenerationDescription(primary));
        } else {
            lines.addAll(this.attributeLines(primary));
        }
        return lines;
    }

    private class_2561 multiEffectHeading(class_1799 stack, class_1293 reference) {
        class_5250 heading = stack.method_7964().method_27661();
        if (!((class_1291)reference.method_5579().comp_349()).method_5561()) {
            heading = heading.method_10852((class_2561)class_2561.method_43470((String)(" (" + this.formatDuration(reference) + ")")));
        }
        return heading;
    }

    private class_2561 multiEffectLine(List<class_1293> effects) {
        class_5250 line = class_2561.method_43473();
        boolean first = true;
        for (class_1293 effect : effects) {
            if (!first) {
                line = line.method_10852((class_2561)class_2561.method_43470((String)"  "));
            }
            class_5250 label = this.effectLabel(effect);
            class_124 color = ((class_1291)effect.method_5579().comp_349()).method_5573() ? class_124.field_1078 : class_124.field_1061;
            line = line.method_10852((class_2561)label.method_27692(color));
            first = false;
        }
        return line;
    }

    private class_5250 effectLabel(class_1293 effect) {
        class_5250 label = class_2561.method_43471((String)effect.method_5586());
        if (effect.method_5578() > 0) {
            label = label.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43471((String)("potion.potency." + effect.method_5578())));
        }
        return label;
    }

    private String formatDuration(class_1293 effect) {
        if (effect.method_48559()) {
            return "\u221e";
        }
        int totalSeconds = Math.max(0, effect.method_5584() / 20);
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format(Locale.ROOT, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%d:%02d", minutes, seconds);
    }

    private class_2561 instantDamageDescription(class_1293 effect) {
        int level = effect.method_5578();
        int damage = switch (level) {
            case 0 -> 6;
            case 1 -> 12;
            default -> 6 * (level + 1);
        };
        return class_2561.method_43470((String)(damage + " damage")).method_27692(class_124.field_1079);
    }

    private class_2561 regenerationDescription(class_1293 effect) {
        String rate;
        String total;
        int seconds = effect.method_5584() / 20;
        int amp = effect.method_5578();
        if (amp == 0 && seconds >= 85) {
            total = "36";
            rate = "0.4";
        } else if (amp == 0) {
            total = "18";
            rate = "0.4";
        } else if (amp == 1) {
            total = "17.6";
            rate = "0.8";
        } else {
            double calcRate = 0.4 * (double)(amp + 1);
            double calcTotal = calcRate * (double)seconds;
            total = ATTRIBUTE_FORMAT.format(calcTotal);
            rate = ATTRIBUTE_FORMAT.format(calcRate);
        }
        return class_2561.method_43470((String)("+" + total + " health (" + rate + " per second)")).method_27692(class_124.field_1078);
    }

    private List<class_2561> attributeLines(class_1293 effect) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ((class_1291)effect.method_5579().comp_349()).method_55650(effect.method_5578(), (attributeEntry, modifier) -> {
            double displayAmount;
            class_1322.class_1323 operation = modifier.comp_2450();
            double amount = modifier.comp_2449();
            double d = displayAmount = operation == class_1322.class_1323.field_6328 ? amount : amount * 100.0;
            if (displayAmount == 0.0) {
                return;
            }
            String formatted = ATTRIBUTE_FORMAT.format(Math.abs(displayAmount));
            class_5250 attribute = class_2561.method_43471((String)((class_1320)attributeEntry.comp_349()).method_26830());
            if (displayAmount > 0.0) {
                lines.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + operation.method_56082()), (Object[])new Object[]{formatted, attribute}).method_27692(class_124.field_1078));
            } else {
                lines.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + operation.method_56082()), (Object[])new Object[]{formatted, attribute}).method_27692(class_124.field_1061));
            }
        });
        return lines;
    }

    private boolean isEffect(class_1293 instance, class_6880<class_1291> effect) {
        return instance.method_5579().comp_349() == effect.comp_349();
    }

    private static class_1844 contents(class_1799 stack) {
        return (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
    }

    private int withOpacity(int baseColor, float opacity) {
        float clamped = class_3532.method_15363((float)opacity, (float)0.05f, (float)1.0f);
        int alpha = baseColor >>> 24 & 0xFF;
        if (alpha == 0) {
            alpha = 255;
        }
        alpha = class_3532.method_15340((int)Math.round((float)alpha * clamped), (int)0, (int)255);
        return alpha << 24 | baseColor & 0xFFFFFF;
    }

    private void drawTextOverlay(class_332 drawContext, class_310 client, class_2561 text, int x, int y, int color) {
        drawContext.method_51439(client.field_1772, text, x, y, color, false);
    }

    private static Map<class_2960, Supplier<class_2561>> createSingleNotes() {
        HashMap<class_2960, Supplier<class_2561>> notes = new HashMap<class_2960, Supplier<class_2561>>();
        notes.put(PotionHudOverlay.id("regeneration"), PotionHudOverlay.literal("+18 health (+0.4 health per second)", class_124.field_1078));
        notes.put(PotionHudOverlay.id("long_regeneration"), PotionHudOverlay.literal("+36 health (+0.4 health per second)", class_124.field_1078));
        notes.put(PotionHudOverlay.id("strong_regeneration"), PotionHudOverlay.literal("+17.6 health (+0.8 health per second)", class_124.field_1078));
        notes.put(PotionHudOverlay.id("healing"), PotionHudOverlay.literal("+4 health (instant)", class_124.field_1078));
        notes.put(PotionHudOverlay.id("strong_healing"), PotionHudOverlay.literal("+8 health (instant)", class_124.field_1078));
        notes.put(PotionHudOverlay.id("harming"), PotionHudOverlay.literal("-6 health", class_124.field_1061));
        notes.put(PotionHudOverlay.id("strong_harming"), PotionHudOverlay.literal("-12 health", class_124.field_1061));
        notes.put(PotionHudOverlay.id("fire_resistance"), PotionHudOverlay.literal("Immune to all fire and lava damage"));
        notes.put(PotionHudOverlay.id("long_fire_resistance"), PotionHudOverlay.literal("Immune to all fire and lava damage"));
        notes.put(PotionHudOverlay.id("water_breathing"), PotionHudOverlay.literal("Unlimited air underwater"));
        notes.put(PotionHudOverlay.id("long_water_breathing"), PotionHudOverlay.literal("Unlimited air underwater"));
        notes.put(PotionHudOverlay.id("night_vision"), PotionHudOverlay.literal("Full visibility in darkness and underwater"));
        notes.put(PotionHudOverlay.id("long_night_vision"), PotionHudOverlay.literal("Full visibility in darkness and underwater"));
        notes.put(PotionHudOverlay.id("invisibility"), PotionHudOverlay.literal("Invisible to players and mobs (short range detection)"));
        notes.put(PotionHudOverlay.id("long_invisibility"), PotionHudOverlay.literal("Invisible to players and mobs (short range detection)"));
        notes.put(PotionHudOverlay.id("slow_falling"), PotionHudOverlay.literal("No fall damage; much slower fall speed"));
        notes.put(PotionHudOverlay.id("long_slow_falling"), PotionHudOverlay.literal("No fall damage; much slower fall speed"));
        notes.put(PotionHudOverlay.id("poison"), PotionHudOverlay.literal("-36 health (-0.8 health per second, stops at 1 health)", class_124.field_1061));
        notes.put(PotionHudOverlay.id("long_poison"), PotionHudOverlay.literal("-72 health (-0.8 health per second, stops at 1 health)", class_124.field_1061));
        notes.put(PotionHudOverlay.id("strong_poison"), PotionHudOverlay.literal("-38 health (-1.6 health per second, stops at 1 health)", class_124.field_1061));
        notes.put(PotionHudOverlay.id("infested"), PotionHudOverlay.literal("Chance to spawn 1-3 silverfish when taking damage"));
        notes.put(PotionHudOverlay.id("oozing"), PotionHudOverlay.literal("Spawns 2 medium slimes on death"));
        notes.put(PotionHudOverlay.id("weaving"), PotionHudOverlay.literal("Places 2-3 cobwebs after death in a 3x3x3 area"));
        notes.put(PotionHudOverlay.id("wind_charged"), PotionHudOverlay.literal("Pushes nearby entities away when you die"));
        return notes;
    }

    private static Map<class_2960, Supplier<class_2561>> createMultiNotes() {
        HashMap<class_2960, Supplier<class_2561>> notes = new HashMap<class_2960, Supplier<class_2561>>();
        notes.put(PotionHudOverlay.id("turtle_master"), PotionHudOverlay.turtleLine("Slowness IV", "Resistance III"));
        notes.put(PotionHudOverlay.id("long_turtle_master"), PotionHudOverlay.turtleLine("Slowness IV", "Resistance III"));
        notes.put(PotionHudOverlay.id("strong_turtle_master"), PotionHudOverlay.turtleLine("Slowness VI", "Resistance IV"));
        return notes;
    }

    private static Supplier<class_2561> literal(String value) {
        return () -> class_2561.method_43470((String)value);
    }

    private static Supplier<class_2561> literal(String value, class_124 color) {
        return () -> class_2561.method_43470((String)value).method_27692(color);
    }

    private static Supplier<class_2561> turtleLine(String slowness, String resistance) {
        return () -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)slowness).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)resistance).method_27692(class_124.field_1078));
    }

    private static class_2960 id(String path) {
        return class_2960.method_60655((String)"minecraft", (String)path);
    }

    private static class_2960 potionId(class_1844 contents) {
        class_6880 entry = contents.comp_2378().orElse(null);
        return entry != null ? class_7923.field_41179.method_10221((Object)((class_1842)entry.comp_349())) : null;
    }

    private static class_2561 singleNoteFor(class_2960 potionId) {
        Supplier<class_2561> supplier = potionId != null ? SINGLE_POTION_NOTES.get(potionId) : null;
        return supplier != null ? supplier.get() : null;
    }

    private static class_2561 multiNoteFor(class_2960 potionId) {
        Supplier<class_2561> supplier = potionId != null ? MULTI_POTION_NOTES.get(potionId) : null;
        return supplier != null ? supplier.get() : null;
    }

    @Environment(value=EnvType.CLIENT)
    private record HudEntry(class_1799 sample, int count) {
        HudEntry incremented(int delta) {
            return new HudEntry(this.sample, this.count + delta);
        }
    }
}

