/*
 * Decompiled with CFR 0.152.
 */
package de.dragonixmc.potionrestock.client.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public record PotionDescriptor(class_2960 itemId, class_6880<class_1842> potionEntry, List<CustomEffectFingerprint> customEffects, Set<class_2960> effectTypes) {
    public static PotionDescriptor from(class_1799 stack) {
        class_1844 contents = PotionDescriptor.contents(stack);
        return new PotionDescriptor(class_7923.field_41178.method_10221((Object)stack.method_7909()), (class_6880<class_1842>)((class_6880)contents.comp_2378().orElse(null)), Collections.unmodifiableList(PotionDescriptor.extractCustomEffects(contents)), Collections.unmodifiableSet(PotionDescriptor.extractEffectTypes(contents)));
    }

    public boolean matchesExact(class_1799 stack) {
        if (!(stack.method_7909() instanceof class_1812)) {
            return false;
        }
        if (!class_7923.field_41178.method_10221((Object)stack.method_7909()).equals((Object)this.itemId)) {
            return false;
        }
        class_1844 contents = PotionDescriptor.contents(stack);
        return Objects.equals(contents.comp_2378().orElse(null), this.potionEntry) && PotionDescriptor.extractCustomEffects(contents).equals(this.customEffects);
    }

    public boolean matchesByEffectTypes(class_1799 stack) {
        if (!(stack.method_7909() instanceof class_1812)) {
            return false;
        }
        if (!class_7923.field_41178.method_10221((Object)stack.method_7909()).equals((Object)this.itemId)) {
            return false;
        }
        return PotionDescriptor.extractEffectTypes(PotionDescriptor.contents(stack)).equals(this.effectTypes);
    }

    private static List<CustomEffectFingerprint> extractCustomEffects(class_1844 contents) {
        List custom = contents.comp_2380();
        if (custom.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CustomEffectFingerprint> fingerprints = new ArrayList<CustomEffectFingerprint>(custom.size());
        for (class_1293 effect : custom) {
            class_2960 id = PotionDescriptor.effectId(effect);
            if (id == null) continue;
            fingerprints.add(new CustomEffectFingerprint(id, effect.method_5578(), effect.method_5584()));
        }
        return fingerprints;
    }

    private static Set<class_2960> extractEffectTypes(class_1844 contents) {
        LinkedHashSet<class_2960> identifiers = new LinkedHashSet<class_2960>();
        for (class_1293 effect : contents.method_57397()) {
            class_2960 id = PotionDescriptor.effectId(effect);
            if (id == null) continue;
            identifiers.add(id);
        }
        return identifiers;
    }

    private static class_2960 effectId(class_1293 effectInstance) {
        return effectInstance.method_5579().method_40230().map(class_5321::method_29177).orElse(null);
    }

    private static class_1844 contents(class_1799 stack) {
        return (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
    }

    @Environment(value=EnvType.CLIENT)
    public record CustomEffectFingerprint(class_2960 effectId, int amplifier, int duration) {
    }
}

