/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.debug;

import aqario.fowlplay.client.FowlPlayClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BirdDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    public static final BirdDebugRenderer INSTANCE = new BirdDebugRenderer();
    private final Minecraft client;
    private final Map<UUID, BirdData> birds = Maps.newHashMap();
    @Nullable
    private UUID targetedEntity;

    private BirdDebugRenderer() {
        this.client = Minecraft.m_91087_();
    }

    public void m_5630_() {
        this.targetedEntity = null;
    }

    public void addBird(BirdData birdData) {
        this.birds.put(birdData.uuid(), birdData);
    }

    private boolean isTargeted(BirdData birdData) {
        return Objects.equals(this.targetedEntity, birdData.uuid());
    }

    public void m_7790_(PoseStack matrices, MultiBufferSource vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        if (!FowlPlayClient.DEBUG_BIRD) {
            return;
        }
        this.removeRemovedBirds();
        this.draw(matrices, vertexConsumers, cameraX, cameraY, cameraZ);
        this.updateTargetedEntity();
    }

    private void removeRemovedBirds() {
        this.birds.entrySet().removeIf(entry -> {
            Entity entity = this.client.f_91073_.m_6815_(((BirdData)entry.getValue()).entityId());
            return entity == null || entity.m_213877_();
        });
    }

    private void updateTargetedEntity() {
        DebugRenderer.m_113448_((Entity)this.client.m_91288_(), (int)8).ifPresent(entity -> {
            this.targetedEntity = entity.m_20148_();
        });
    }

    private boolean isClose(BirdData birdData) {
        LocalPlayer playerEntity = this.client.f_91074_;
        BlockPos playerPos = BlockPos.m_274561_((double)playerEntity.m_20185_(), (double)birdData.pos().m_7098_(), (double)playerEntity.m_20189_());
        BlockPos brainPos = BlockPos.m_274446_((Position)birdData.pos());
        return playerPos.m_123314_((Vec3i)brainPos, 30.0);
    }

    private void draw(PoseStack matrices, MultiBufferSource vertexConsumers, double x, double y, double z) {
        this.birds.values().forEach(birdData -> {
            if (this.isClose((BirdData)birdData)) {
                BirdDebugRenderer.drawBirdData(matrices, vertexConsumers, birdData, this.isTargeted((BirdData)birdData), x, y, z);
            }
        });
    }

    private static void drawBirdData(PoseStack matrices, MultiBufferSource vertexConsumers, BirdData birdData, boolean targeted, double cameraX, double cameraY, double cameraZ) {
        int i = 0;
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, birdData.name(), -1, 0.03f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "trusting: " + Arrays.toString(birdData.trusting().toArray()), -3355444, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "flying: " + birdData.flying(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "perched: " + birdData.perched(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "ambient: " + birdData.ambient(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "move control: " + birdData.moveControl(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "navigation: " + birdData.navigation(), -1, 0.02f);
        int j = birdData.health() < birdData.maxHealth() ? -23296 : -1;
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "health: " + String.format(Locale.ROOT, "%.1f", Float.valueOf(birdData.health())) + " / " + String.format(Locale.ROOT, "%.1f", Float.valueOf(birdData.maxHealth())), j, 0.02f);
        ++i;
        if (!birdData.inventory().isEmpty()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, birdData.inventory(), -98404, 0.02f);
        }
        for (String string : birdData.runningTasks()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, string, -16711681, 0.02f);
            ++i;
        }
        for (String string : birdData.possibleActivities()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, string, -16711936, 0.02f);
            ++i;
        }
        if (birdData.schedule() != null) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, birdData.schedule(), -23296, 0.02f);
            ++i;
        }
        if (targeted) {
            for (String string : Lists.reverse(birdData.memories())) {
                BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, string, -3355444, 0.02f);
                ++i;
            }
        }
        BirdDebugRenderer.drawPath(matrices, vertexConsumers, birdData, cameraX, cameraY, cameraZ);
    }

    private static void drawPath(PoseStack matrices, MultiBufferSource vertexConsumers, BirdData birdData, double cameraX, double cameraY, double cameraZ) {
        if (birdData.path() != null) {
            if (birdData.flying()) {
                BirdDebugRenderer.drawPath(matrices, vertexConsumers, birdData.path(), 0.1f, false, false, cameraX, cameraY, cameraZ);
            } else {
                PathfindingRenderer.m_269027_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (Path)birdData.path(), (float)0.5f, (boolean)false, (boolean)false, (double)cameraX, (double)cameraY, (double)cameraZ);
            }
        }
    }

    public static void drawPath(PoseStack matrices, MultiBufferSource vertexConsumers, Path path, float nodeSize, boolean drawDebugNodes, boolean drawLabels, double cameraX, double cameraY, double cameraZ) {
        PathfindingRenderer.m_269170_((PoseStack)matrices, (VertexConsumer)vertexConsumers.m_6299_(RenderType.m_269399_((double)6.0)), (Path)path, (double)cameraX, (double)cameraY, (double)cameraZ);
        BlockPos blockPos = path.m_77406_();
        if (BirdDebugRenderer.getManhattanDistance(blockPos, cameraX, cameraY, cameraZ) <= 80.0f) {
            DebugRenderer.m_269311_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)blockPos.m_123341_() + 0.25f), (double)((float)blockPos.m_123342_() + 0.25f), (double)blockPos.m_123343_() + 0.25, (double)((float)blockPos.m_123341_() + 0.75f), (double)((float)blockPos.m_123342_() + 0.75f), (double)((float)blockPos.m_123343_() + 0.75f)).m_82386_(-cameraX, -cameraY, -cameraZ), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            for (int i = 0; i < path.m_77398_(); ++i) {
                Node pathNode = path.m_77375_(i);
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode.m_77288_(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                float f = i == path.m_77399_() ? 1.0f : 0.0f;
                float g = i == path.m_77399_() ? 0.0f : 1.0f;
                DebugRenderer.m_269311_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)pathNode.f_77271_ + 0.5f - nodeSize), (double)((float)pathNode.f_77272_ + 0.5f - nodeSize), (double)((float)pathNode.f_77273_ + 0.5f - nodeSize), (double)((float)pathNode.f_77271_ + 0.5f + nodeSize), (double)((float)pathNode.f_77272_ + 0.5f + nodeSize), (double)((float)pathNode.f_77273_ + 0.5f + nodeSize)).m_82386_(-cameraX, -cameraY, -cameraZ), (float)f, (float)0.0f, (float)g, (float)0.5f);
            }
        }
        if (drawDebugNodes) {
            for (Node pathNode2 : path.m_77405_()) {
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode2.m_77288_(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                DebugRenderer.m_269311_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)pathNode2.f_77271_ + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.f_77272_ + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.f_77273_ + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.f_77271_ + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2.f_77272_ + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2.f_77273_ + 0.5f + nodeSize / 2.0f)).m_82386_(-cameraX, -cameraY, -cameraZ), (float)1.0f, (float)0.8f, (float)0.8f, (float)0.5f);
            }
            for (Node pathNode2x : path.m_77404_()) {
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode2x.m_77288_(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                DebugRenderer.m_269311_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)pathNode2x.f_77271_ + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.f_77272_ + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.f_77273_ + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.f_77271_ + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2x.f_77272_ + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2x.f_77273_ + 0.5f + nodeSize / 2.0f)).m_82386_(-cameraX, -cameraY, -cameraZ), (float)0.8f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
        }
        if (drawLabels) {
            for (int ix = 0; ix < path.m_77398_(); ++ix) {
                Node pathNode = path.m_77375_(ix);
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode.m_77288_(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                DebugRenderer.m_269439_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)String.valueOf(pathNode.f_77282_), (double)((double)pathNode.f_77271_ + 0.5), (double)((double)pathNode.f_77272_ + 0.75), (double)((double)pathNode.f_77273_ + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
                DebugRenderer.m_269439_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)String.format(Locale.ROOT, "%.2f", Float.valueOf(pathNode.f_77281_)), (double)((double)pathNode.f_77271_ + 0.5), (double)((double)pathNode.f_77272_ + 0.25), (double)((double)pathNode.f_77273_ + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
            }
        }
    }

    private static float getManhattanDistance(BlockPos pos, double x, double y, double z) {
        return (float)(Math.abs((double)pos.m_123341_() - x) + Math.abs((double)pos.m_123342_() - y) + Math.abs((double)pos.m_123343_() - z));
    }

    private static void drawString(PoseStack matrices, MultiBufferSource vertexConsumers, String string, BrainDebugRenderer.PoiInfo pointOfInterest, int offsetY, int color) {
        BirdDebugRenderer.drawString(matrices, vertexConsumers, string, pointOfInterest.f_113333_, offsetY, color);
    }

    private static void drawString(PoseStack matrices, MultiBufferSource vertexConsumers, String string, BlockPos pos, int offsetY, int color) {
        double f = (double)pos.m_123341_() + 0.5;
        double g = (double)pos.m_123342_() + 1.3 + (double)offsetY * 0.2;
        double h = (double)pos.m_123343_() + 0.5;
        DebugRenderer.m_269439_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)string, (double)f, (double)g, (double)h, (int)color, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
    }

    private static void drawString(PoseStack matrices, MultiBufferSource vertexConsumers, Position pos, int offsetY, String string, int color, float size) {
        double f = pos.m_7096_() + 0.5;
        double g = pos.m_7098_() + 2.4 + (double)offsetY * 0.25;
        double h = pos.m_7094_() + 0.5;
        DebugRenderer.m_269439_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)string, (double)f, (double)g, (double)h, (int)color, (float)size, (boolean)false, (float)0.5f, (boolean)true);
    }

    public record BirdData(UUID uuid, int entityId, String name, String moveControl, String navigation, float health, float maxHealth, Vec3 pos, String inventory, @Nullable Path path, List<String> trusting, boolean flying, boolean ambient, boolean perched, List<String> possibleActivities, List<String> runningTasks, List<String> memories, @Nullable String schedule, Set<BlockPos> pois, Set<BlockPos> potentialPois) {
        public BirdData(FriendlyByteBuf buf) {
            this(buf.m_130259_(), buf.readInt(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readFloat(), buf.readFloat(), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.m_130277_(), (Path)buf.m_236868_(Path::m_77390_), buf.m_236845_(FriendlyByteBuf::m_130277_), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.m_236845_(FriendlyByteBuf::m_130277_), buf.m_236845_(FriendlyByteBuf::m_130277_), buf.m_236845_(FriendlyByteBuf::m_130277_), (String)buf.m_236868_(FriendlyByteBuf::m_130277_), (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130135_), (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130135_));
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130077_(this.uuid);
            buf.writeInt(this.entityId);
            buf.m_130070_(this.name);
            buf.m_130070_(this.moveControl);
            buf.m_130070_(this.navigation);
            buf.writeFloat(this.health);
            buf.writeFloat(this.maxHealth);
            buf.writeDouble(this.pos.m_7096_());
            buf.writeDouble(this.pos.m_7098_());
            buf.writeDouble(this.pos.m_7094_());
            buf.m_130070_(this.inventory);
            buf.m_236821_((Object)this.path, (bufx, pathx) -> pathx.m_164704_(bufx));
            buf.m_236828_(this.trusting, FriendlyByteBuf::m_130070_);
            buf.writeBoolean(this.flying);
            buf.writeBoolean(this.ambient);
            buf.writeBoolean(this.perched);
            buf.m_236828_(this.possibleActivities, FriendlyByteBuf::m_130070_);
            buf.m_236828_(this.runningTasks, FriendlyByteBuf::m_130070_);
            buf.m_236828_(this.memories, FriendlyByteBuf::m_130070_);
            buf.m_236821_((Object)this.schedule, FriendlyByteBuf::m_130070_);
            buf.m_236828_(this.pois, FriendlyByteBuf::m_130064_);
            buf.m_236828_(this.potentialPois, FriendlyByteBuf::m_130064_);
        }
    }
}

