/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GullVariant;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomFlightTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomLookTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.control.BirdFloatMoveControl;
import aqario.fowlplay.common.entity.ai.pathing.AmphibiousNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class GullEntity
extends TrustingBirdEntity
implements BirdBrain<GullEntity>,
VariantHolder<GullVariant> {
    private static final EntityDataAccessor<GullVariant> VARIANT = SynchedEntityData.m_135353_(GullEntity.class, FowlPlayTrackedDataHandlerRegistry.GULL_VARIANT);
    public final AnimationState standingState = new AnimationState();
    public final AnimationState glidingState = new AnimationState();
    public final AnimationState flappingState = new AnimationState();
    public final AnimationState floatingState = new AnimationState();

    public GullEntity(EntityType<? extends GullEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.7f;
    }

    @Override
    protected MoveControl createMoveControl() {
        return new BirdFloatMoveControl(this);
    }

    @Override
    public int getMaxPitchChange() {
        return 18;
    }

    @Override
    public int getMaxYawChange() {
        return 18;
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)24, (Object)32);
    }

    @Override
    protected PathNavigation getLandNavigation() {
        return new AmphibiousNavigation((Mob)this, this.m_9236_());
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        FowlPlayRegistries.GULL_VARIANT.get().fowlplay$getRandom(world.m_213780_()).ifPresent(this::setVariant);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean canSwim() {
        return true;
    }

    @Override
    public int getFlapFrequency() {
        return 0;
    }

    public static AttributeSupplier.Builder createGullAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.225f).m_22268_(Attributes.f_22280_, (double)0.22f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)GullVariant.HERRING.get());
    }

    public GullVariant getVariant() {
        return (GullVariant)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(GullVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("variant", FowlPlayRegistries.GULL_VARIANT.get().fowlplay$getId(this.getVariant()).toString());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        GullVariant variant = FowlPlayRegistries.GULL_VARIANT.get().fowlplay$get(ResourceLocation.m_135820_((String)nbt.m_128461_("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
    }

    public boolean m_6162_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.m_204132_(FowlPlayItemTags.GULL_FOOD);
    }

    @Override
    public boolean canHunt(LivingEntity target) {
        return target.m_6095_().m_204039_(FowlPlayEntityTypeTags.GULL_HUNT_TARGETS) || target.m_6095_().m_204039_(FowlPlayEntityTypeTags.GULL_BABY_HUNT_TARGETS) && target.m_6162_();
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.GULL_AVOIDS);
    }

    @Override
    public void updateAnimations() {
        this.standingState.m_246184_(!this.isFlying() && !this.m_20072_(), this.f_19797_);
        this.glidingState.m_246184_(this.isFlying(), this.f_19797_);
        this.floatingState.m_246184_(!this.isFlying() && this.m_20072_(), this.f_19797_);
    }

    protected boolean m_142039_() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.8f;
    }

    @Override
    public float getFlapPitch() {
        return 0.6f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_GULL_CALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSongSound() {
        return FowlPlaySoundEvents.ENTITY_GULL_LONG_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().gullCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().gullSongVolume;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_GULL_HURT.get();
    }

    @Override
    public float getWaterline() {
        return 0.35f;
    }

    @Override
    public CylindricalRadius getWalkRange() {
        return new CylindricalRadius(24, 12);
    }

    protected Brain.Provider<GullEntity> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends GullEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends GullEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{FlightBehaviours.stopFalling(), new SetAttackTarget(), new LookAtTarget().runFor(entity -> entity.m_217043_().m_216332_(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends GullEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends GullEntity> getFightTasks() {
        return BirdBrain.fightActivity(new Behavior[]{new InvalidateAttackTarget(), FlightBehaviours.startFlying(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0), CustomBehaviours.forgetUnderwaterAttackTarget()});
    }

    public BrainActivityGroup<? extends GullEntity> getIdleTasks() {
        return BirdBrain.idleActivity(new Behavior[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new SetRandomLookTarget().lookChance(0.02f)});
    }

    @Override
    public BrainActivityGroup<? extends GullEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CustomBehaviours.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends GullEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{CustomBehaviours.setWaterRestTarget(), CustomBehaviours.idleIfInWater()});
    }

    @Override
    public BrainActivityGroup<GullEntity> getSoarTasks() {
        return BirdBrain.soarActivity(new Behavior[]{new SetRandomFlightTarget().startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_))});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.SEABIRD.get();
    }

    protected void m_8024_() {
        Brain brain = this.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        this.tickBrain((LivingEntity)this);
        if (activity == Activity.f_37988_ && brain.m_21968_().orElse(null) != Activity.f_37988_) {
            brain.m_21882_(MemoryModuleType.f_148201_, (Object)true, 2400L);
        }
        super.m_8024_();
    }
}

