/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.TeleportTarget;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class TeleportToTarget
extends ExtendedBehaviour<BirdEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(1).present((MemoryModuleType<?>)FowlPlayMemoryModuleType.TELEPORT_TARGET.get());

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean shouldKeepRunning(BirdEntity entity) {
        return BrainUtils.hasMemory((LivingEntity)entity, FowlPlayMemoryModuleType.TELEPORT_TARGET.get());
    }

    protected void tick(BirdEntity entity) {
        Brain brain = entity.m_6274_();
        if (this.tryTeleport(entity, brain)) {
            BrainUtils.clearMemory((Brain)brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get());
        }
    }

    private boolean tryTeleport(BirdEntity entity, Brain<?> brain) {
        if (!BrainUtils.hasMemory(brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get())) {
            return false;
        }
        Entity target = ((TeleportTarget)BrainUtils.getMemory(brain, FowlPlayMemoryModuleType.TELEPORT_TARGET.get())).entity();
        BlockPos pos = target.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = entity.m_217043_().m_216332_(-3, 3);
            int k = entity.m_217043_().m_216332_(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = entity.m_217043_().m_216332_(-1, 1);
            if (!this.tryTeleportTo(entity, pos.m_123341_() + j, pos.m_123342_() + l, pos.m_123343_() + k)) continue;
            return true;
        }
        return false;
    }

    private boolean tryTeleportTo(BirdEntity entity, int x, int y, int z) {
        if (!this.canTeleportTo(entity, new BlockPos(x, y, z))) {
            return false;
        }
        entity.m_7678_((double)x + 0.5, y, (double)z + 0.5, entity.m_146908_(), entity.m_146909_());
        entity.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleportTo(BirdEntity entity, BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)entity.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos distance = pos.m_121996_((Vec3i)entity.m_20183_());
        return entity.m_9236_().m_45756_((Entity)entity, entity.m_20191_().m_82338_(distance));
    }
}

