/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.pathing;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.pathing.ExtendedRandomPos;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.TargetingUtil;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BirdTargeting {
    @Nullable
    public static Vec3 findWaterOrGround(BirdEntity entity, CylindricalRadius waterRange, CylindricalRadius groundRange) {
        Vec3 pos = BirdTargeting.findWater(entity, waterRange);
        return pos != null ? pos : BirdTargeting.findGround(entity, groundRange);
    }

    @Nullable
    public static Vec3 findWater(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.validateWater((PathfinderMob)entity, ExtendedRandomPos.withinRangePreferFar(entity.m_217043_(), range.horizontal(), range.vertical()));
        return pos != null ? Vec3.m_82539_((Vec3i)pos) : null;
    }

    @Nullable
    public static Vec3 findNonAir(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.validateNonAir((PathfinderMob)entity, ExtendedRandomPos.withinRangePreferFar(entity.m_217043_(), range.horizontal(), range.vertical()));
        return pos != null ? Vec3.m_82539_((Vec3i)pos) : null;
    }

    @Nullable
    public static Vec3 findPerchOrGround(BirdEntity entity, CylindricalRadius perchRange, CylindricalRadius groundRange) {
        Vec3 pos = BirdTargeting.findPerch(entity, perchRange);
        return pos != null ? pos : BirdTargeting.findGround(entity, groundRange);
    }

    @Nullable
    public static Vec3 findGround(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.validateGround((PathfinderMob)entity, ExtendedRandomPos.withinRangePreferFar(entity.m_217043_(), range.horizontal(), range.vertical()));
        return pos != null ? Vec3.m_82539_((Vec3i)pos) : null;
    }

    @Nullable
    public static Vec3 findPerch(BirdEntity entity, CylindricalRadius range) {
        return BirdTargeting.findPerch(entity, range, pos -> 0.0);
    }

    @Nullable
    public static Vec3 findPerch(BirdEntity entity, CylindricalRadius range, ToDoubleFunction<BlockPos> scorer) {
        boolean posTargetInRange = GoalUtils.m_148442_((PathfinderMob)entity, (int)range.horizontal());
        Vec3 direction = entity.m_20252_(1.0f);
        return RandomPos.m_148561_(() -> {
            BlockPos pos = ExtendedRandomPos.withinAngleSlicePreferNear(entity.m_217043_(), range.horizontal(), range.vertical(), 0, direction, 4.71238898038469);
            BlockPos shiftedPos = TargetingUtil.towardTarget((PathfinderMob)entity, range.horizontal(), posTargetInRange, pos);
            return shiftedPos != null ? TargetingUtil.validatePerch((PathfinderMob)entity, shiftedPos) : null;
        }, scorer);
    }

    @Nullable
    public static Vec3 findAir(FlyingBirdEntity entity, CylindricalRadius range) {
        return BirdTargeting.findAir(entity, range, entity::getFlyingPathfindingFavor);
    }

    @Nullable
    public static Vec3 findAir(FlyingBirdEntity entity, CylindricalRadius range, ToDoubleFunction<BlockPos> scorer) {
        boolean posTargetInRange = GoalUtils.m_148442_((PathfinderMob)entity, (int)range.horizontal());
        Vec3 direction = entity.m_20252_(1.0f);
        double angle = 15.0;
        return RandomPos.m_148561_(() -> {
            BlockPos pos = ExtendedRandomPos.withinAngleSlicePreferFar(entity.m_217043_(), range.horizontal(), range.vertical(), 0, direction, 0.2617993877991494);
            BlockPos shiftedPos = TargetingUtil.towardTarget((PathfinderMob)entity, range.horizontal(), posTargetInRange, pos);
            return shiftedPos != null ? TargetingUtil.validateAny((PathfinderMob)entity, shiftedPos) : null;
        }, scorer);
    }

    @Nullable
    public static Vec3 findTo(FlyingBirdEntity entity, int horizontalRange, int verticalRange, Vec3 end) {
        Vec3 vec3d = end.m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        boolean bl = GoalUtils.m_148442_((PathfinderMob)entity, (int)horizontalRange);
        return BirdTargeting.findValid(entity, horizontalRange, verticalRange, vec3d, bl);
    }

    @Nullable
    public static Vec3 findFrom(FlyingBirdEntity entity, int horizontalRange, int verticalRange, Vec3 start) {
        Vec3 vec3d = entity.m_20182_().m_82546_(start);
        boolean bl = GoalUtils.m_148442_((PathfinderMob)entity, (int)horizontalRange);
        return BirdTargeting.findValid(entity, horizontalRange, verticalRange, vec3d, bl);
    }

    @Nullable
    private static Vec3 findValid(FlyingBirdEntity entity, int horizontalRange, int verticalRange, Vec3 direction, boolean posTargetInRange) {
        return RandomPos.m_148542_((PathfinderMob)entity, () -> {
            BlockPos blockPos = ExtendedRandomPos.withinAngleSlicePreferNear(entity.m_217043_(), horizontalRange, verticalRange, 0, direction, 1.5707963267948966);
            BlockPos blockPos2 = TargetingUtil.towardTarget((PathfinderMob)entity, horizontalRange, posTargetInRange, blockPos);
            return blockPos2 == null ? null : TargetingUtil.validateAny((PathfinderMob)entity, blockPos2);
        });
    }
}

