/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.world.gen;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.core.FowlPlayEntityType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class SparrowSpawner
implements CustomSpawner {
    private static final int SPAWN_COOLDOWN = 2400;
    private static final int MAX_SPARROWS = 12;
    private int ticksUntilNextSpawn;

    public int m_7995_(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        if (!spawnAnimals || !world.m_46469_().m_46207_(GameRules.f_46134_) || FowlPlayConfig.getInstance().sparrowSpawnWeight <= 0) {
            return 0;
        }
        --this.ticksUntilNextSpawn;
        if (this.ticksUntilNextSpawn > 0) {
            return 0;
        }
        this.ticksUntilNextSpawn = 2400;
        ServerPlayer player = world.m_8890_();
        if (player == null) {
            return 0;
        }
        RandomSource random = world.f_46441_;
        int x = (8 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
        int z = (8 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
        BlockPos pos = player.m_20183_().m_7918_(x, 0, z);
        if (!world.m_151572_(pos.m_123341_() - 10, pos.m_123343_() - 10, pos.m_123341_() + 10, pos.m_123343_() + 10)) {
            return 0;
        }
        if (world.m_8736_(pos, 2)) {
            return this.spawnNearPoi(world, pos);
        }
        return 0;
    }

    private int spawnNearPoi(ServerLevel world, BlockPos pos) {
        List nearbySparrows;
        if (world.m_8904_().m_27121_(holder -> holder.m_203565_(PoiTypes.f_218060_), pos, 48, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (nearbySparrows = world.m_45976_(SparrowEntity.class, new AABB(pos).m_82377_(48.0, 8.0, 48.0))).size() < 12 && FlyingBirdEntity.canSpawnPasserines(FowlPlayEntityType.SPARROW.get(), (LevelAccessor)world, MobSpawnType.NATURAL, pos, world.m_213780_())) {
            return this.spawn(pos, world);
        }
        return 0;
    }

    private int spawn(BlockPos pos, ServerLevel world) {
        SparrowEntity sparrow = (SparrowEntity)FowlPlayEntityType.SPARROW.get().m_20615_((Level)world);
        if (sparrow == null) {
            return 0;
        }
        sparrow.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.NATURAL, null, null);
        sparrow.m_20035_(pos, 0.0f, 0.0f);
        world.m_47205_((Entity)sparrow);
        return 1;
    }
}

