/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.mixin;

import aqario.fowlplay.core.platform.CustomSpawnGroup;
import aqario.fowlplay.core.platform.CustomSpawnLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class SpawnHelperMixin {
    @Unique
    private static boolean fowlplay$isClearForSpawn(LevelReader world, BlockPos pos, EntityType<?> entityType) {
        BlockState blockState = world.m_8055_(pos);
        return NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.m_60819_(), entityType);
    }

    @Unique
    private static boolean fowlplay$spawnsOnGround(LevelReader world, BlockPos spawnPos, EntityType<?> entityType) {
        if (entityType != null && world.m_6857_().m_61937_(spawnPos)) {
            BlockPos headPos = spawnPos.m_7494_();
            return SpawnHelperMixin.fowlplay$isClearForSpawn(world, spawnPos, entityType) && (entityType.m_20679_() <= 1.0f || SpawnHelperMixin.fowlplay$isClearForSpawn(world, headPos, entityType));
        }
        return false;
    }

    @Unique
    private static boolean fowlplay$spawnsOnWater(LevelReader world, BlockPos spawnPos, EntityType<?> entityType) {
        if (entityType != null && world.m_6857_().m_61937_(spawnPos)) {
            BlockPos headPos = spawnPos.m_7494_();
            return world.m_6425_(spawnPos.m_7495_()).m_205070_(FluidTags.f_13131_) && (entityType.m_20679_() <= 1.0f || SpawnHelperMixin.fowlplay$isClearForSpawn(world, headPos, entityType));
        }
        return false;
    }

    @Inject(method={"canSpawn(Lnet/minecraft/entity/SpawnRestriction$Location;Lnet/minecraft/world/WorldView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/EntityType;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fowlplay$addCustomSpawnLocationChecks(SpawnPlacements.Type location, LevelReader world, BlockPos pos, @Nullable EntityType<?> entityType, CallbackInfoReturnable<Boolean> cir) {
        if (location == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (location == SpawnPlacements.Type.NO_RESTRICTIONS) {
            return;
        }
        if (entityType == null || !world.m_6857_().m_61937_(pos)) {
            return;
        }
        if (location == CustomSpawnLocation.ground()) {
            cir.setReturnValue((Object)SpawnHelperMixin.fowlplay$spawnsOnGround(world, pos, entityType));
        } else if (location == CustomSpawnLocation.semiaquatic()) {
            cir.setReturnValue((Object)(SpawnHelperMixin.fowlplay$spawnsOnWater(world, pos, entityType) || SpawnHelperMixin.fowlplay$spawnsOnGround(world, pos, entityType) ? 1 : 0));
        } else if (location == CustomSpawnLocation.aquatic()) {
            cir.setReturnValue((Object)SpawnHelperMixin.fowlplay$spawnsOnWater(world, pos, entityType));
        }
    }

    @Inject(method={"spawnEntitiesInChunk(Lnet/minecraft/entity/SpawnGroup;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/world/chunk/WorldChunk;Lnet/minecraft/world/SpawnHelper$Checker;Lnet/minecraft/world/SpawnHelper$Runner;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fowlplay$reduceSpawningFrequency(MobCategory group, ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnPredicate checker, NaturalSpawner.AfterSpawnCallback runner, CallbackInfo ci) {
        if (group == CustomSpawnGroup.birds() && world.m_6106_().m_6793_() % 20L != 0L) {
            ci.cancel();
        }
    }

    @Redirect(method={"spawnEntitiesInChunk(Lnet/minecraft/entity/SpawnGroup;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/world/chunk/Chunk;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/SpawnHelper$Checker;Lnet/minecraft/world/SpawnHelper$Runner;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;getY()I"))
    private static int fowlplay$midairSpawning(BlockPos pos, MobCategory group, ServerLevel world) {
        if ((group == CustomSpawnGroup.birds() || group == CustomSpawnGroup.ambientBirds()) && world.m_213780_().m_188501_() < 0.01f && world.m_6106_().m_6793_() % 100L != 0L) {
            return pos.m_123342_() + world.m_213780_().m_216332_(32, 64);
        }
        return pos.m_123342_();
    }
}

