/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.core.FowlPlayItems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1688;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class ScarecrowEntity
extends class_1309
implements class_1265,
class_3908 {
    private static final Predicate<class_1297> RIDEABLE_MINECART_PREDICATE = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    private static final class_2379 DEFAULT_HEAD_ROTATION = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_BODY_ROTATION = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_LEFT_ARM_ROTATION = new class_2379(0.0f, 0.0f, -90.0f);
    private static final class_2379 DEFAULT_RIGHT_ARM_ROTATION = new class_2379(0.0f, 0.0f, 90.0f);
    public static final class_2940<class_2379> HEAD_ROTATION = class_2945.method_12791(ScarecrowEntity.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> BODY_ROTATION = class_2945.method_12791(ScarecrowEntity.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> LEFT_ARM_ROTATION = class_2945.method_12791(ScarecrowEntity.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> RIGHT_ARM_ROTATION = class_2945.method_12791(ScarecrowEntity.class, (class_2941)class_2943.field_13316);
    private class_2379 headRotation = DEFAULT_HEAD_ROTATION;
    private class_2379 bodyRotation = DEFAULT_BODY_ROTATION;
    private class_2379 leftArmRotation = DEFAULT_LEFT_ARM_ROTATION;
    private class_2379 rightArmRotation = DEFAULT_RIGHT_ARM_ROTATION;
    private static final String POSE_KEY = "pose";
    private static final String HEAD_ROTATION_KEY = "head";
    private static final String BODY_ROTATION_KEY = "body";
    private static final String LEFT_ARM_ROTATION_KEY = "left_arm";
    private static final String RIGHT_ARM_ROTATION_KEY = "right_arm";
    private static final String ITEMS_KEY = "items";
    private static final String SLOT_KEY = "slot";
    private static final int INVENTORY_SIZE = 4;
    private static final int HEAD_SLOT = 0;
    private static final int CHEST_SLOT = 1;
    private static final int MAINHAND_SLOT = 2;
    private static final int OFFHAND_SLOT = 3;
    protected class_1277 inventory = new class_1277(4);

    public ScarecrowEntity(class_1299<? extends ScarecrowEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.inventory.method_5489((class_1265)this);
        this.method_49477(0.0f);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 1.72f;
    }

    public static class_5132.class_5133 createScarecrowAttributes() {
        return ScarecrowEntity.method_26827().method_26868(class_5134.field_23718, 1.0);
    }

    protected float method_6031(float bodyRotation, float headRotation) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    public void method_5636(float bodyYaw) {
        this.field_6220 = this.field_5982 = bodyYaw;
        this.field_6259 = this.field_6241 = bodyYaw;
    }

    public void method_5847(float headYaw) {
        this.field_6220 = this.field_5982 = headYaw;
        this.field_6259 = this.field_6241 = headYaw;
    }

    public void method_5453(class_1263 sender) {
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (itemStack.method_7960()) continue;
                this.method_5775(itemStack);
            }
        }
    }

    public Iterable<class_1799> method_5877() {
        return ImmutableList.of((Object)this.inventory.method_5438(2), (Object)this.inventory.method_5438(3));
    }

    public Iterable<class_1799> method_5661() {
        return ImmutableList.of((Object)this.inventory.method_5438(0), (Object)this.inventory.method_5438(1));
    }

    public class_1799 method_6118(class_1304 slot) {
        return switch (slot) {
            case class_1304.field_6169 -> this.inventory.method_5438(0);
            case class_1304.field_6174 -> this.inventory.method_5438(1);
            case class_1304.field_6173 -> this.inventory.method_5438(2);
            case class_1304.field_6171 -> this.inventory.method_5438(3);
            default -> class_1799.field_8037;
        };
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        switch (slot) {
            case field_6169: {
                this.inventory.method_5447(0, stack);
                break;
            }
            case field_6174: {
                this.inventory.method_5447(1, stack);
                break;
            }
            case field_6173: {
                this.inventory.method_5447(2, stack);
                break;
            }
            case field_6171: {
                this.inventory.method_5447(3, stack);
            }
        }
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = ScarecrowEntity.method_32326((class_1799)stack);
        return this.method_6118(equipmentSlot).method_7960();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        this.field_6011.method_12784(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        this.field_6011.method_12784(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFT_ARM_ROTATION);
        this.field_6011.method_12784(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHT_ARM_ROTATION);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10567(SLOT_KEY, (byte)i);
            itemStack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbt.method_10566(ITEMS_KEY, (class_2520)nbtList);
        nbt.method_10566(POSE_KEY, (class_2520)this.poseToNbt());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2499 nbtList = nbt.method_10554(ITEMS_KEY, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571(SLOT_KEY) & 0xFF;
            if (j >= this.inventory.method_5439()) continue;
            this.inventory.method_5447(j, class_1799.method_7915((class_2487)nbtCompound));
        }
        class_2487 poseNbt = nbt.method_10562(POSE_KEY);
        this.readPoseNbt(poseNbt);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_37908().method_8608() && player.method_5998(hand).method_7960() && !player.method_21823()) {
            return class_1269.field_21466;
        }
        return super.method_5688(player, hand);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return null;
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829(), RIDEABLE_MINECART_PREDICATE);
        for (class_1297 entity : list) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().method_8608() || this.method_31481()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5768();
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_5526() instanceof class_1671) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.updateHealth(source, amount);
            return false;
        }
        if (source.method_49708(class_8111.field_42338)) {
            this.method_5639(10);
            if (this.method_5809()) {
                this.updateHealth(source, 1.0f);
            }
            return false;
        }
        if (source.method_48789(class_8103.field_42246)) {
            this.method_5639(5);
            if (this.method_5809()) {
                this.updateHealth(source, 0.05f);
            }
            return false;
        }
        if (source.method_5526() instanceof class_1665) {
            return true;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!player.method_5715()) {
                this.method_32875(class_5712.field_28736, source.method_5529());
                return true;
            }
            if (!player.method_31549().field_7476) {
                return false;
            }
            if (source.method_5530()) {
                this.onBreak(source);
                this.spawnBreakParticles();
                this.method_5768();
                return false;
            }
            this.breakAndDropThis(source);
            this.spawnBreakParticles();
            this.method_5768();
        }
        return true;
    }

    public boolean method_5679(class_1282 damageSource) {
        return damageSource.method_48789(class_8103.field_42250);
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876(class_5712.field_37676);
    }

    protected void spawnBreakParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_14199(this.getParticle(), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void updateHealth(class_1282 damageSource, float amount) {
        float f = this.method_6032();
        if ((f -= amount) <= 0.5f) {
            this.onBreak(damageSource);
            this.method_5768();
        } else {
            this.method_6033(f);
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
        }
    }

    private void breakAndDropThis(class_1282 damageSource) {
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)this.getItem());
        this.onBreak(damageSource);
    }

    private void onBreak(class_1282 damageSource) {
        this.playBreakSound();
        this.method_16080(damageSource);
    }

    private void playBreakSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6002(), this.method_5634(), 1.0f, 1.0f);
    }

    private void readPoseNbt(class_2487 nbt) {
        class_2499 head = nbt.method_10554(HEAD_ROTATION_KEY, 5);
        class_2499 body = nbt.method_10554(BODY_ROTATION_KEY, 5);
        class_2499 leftArm = nbt.method_10554(LEFT_ARM_ROTATION_KEY, 5);
        class_2499 rightArm = nbt.method_10554(RIGHT_ARM_ROTATION_KEY, 5);
        this.setHeadRotation(head.isEmpty() ? DEFAULT_HEAD_ROTATION : new class_2379(head));
        this.setBodyRotation(body.isEmpty() ? DEFAULT_BODY_ROTATION : new class_2379(body));
        this.setLeftArmRotation(leftArm.isEmpty() ? DEFAULT_LEFT_ARM_ROTATION : new class_2379(leftArm));
        this.setRightArmRotation(rightArm.isEmpty() ? DEFAULT_RIGHT_ARM_ROTATION : new class_2379(rightArm));
    }

    private class_2487 poseToNbt() {
        class_2487 nbt = new class_2487();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            nbt.method_10566(HEAD_ROTATION_KEY, (class_2520)this.headRotation.method_10255());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            nbt.method_10566(BODY_ROTATION_KEY, (class_2520)this.bodyRotation.method_10255());
        }
        if (!DEFAULT_LEFT_ARM_ROTATION.equals((Object)this.leftArmRotation)) {
            nbt.method_10566(LEFT_ARM_ROTATION_KEY, (class_2520)this.leftArmRotation.method_10255());
        }
        if (!DEFAULT_RIGHT_ARM_ROTATION.equals((Object)this.rightArmRotation)) {
            nbt.method_10566(RIGHT_ARM_ROTATION_KEY, (class_2520)this.rightArmRotation.method_10255());
        }
        return nbt;
    }

    public class_2379 getHeadRotation() {
        return this.headRotation;
    }

    public class_2379 getBodyRotation() {
        return this.bodyRotation;
    }

    public class_2379 getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public class_2379 getRightArmRotation() {
        return this.rightArmRotation;
    }

    public void setHeadRotation(class_2379 angle) {
        this.headRotation = angle;
        this.field_6011.method_12778(HEAD_ROTATION, (Object)angle);
    }

    public void setBodyRotation(class_2379 angle) {
        this.bodyRotation = angle;
        this.field_6011.method_12778(BODY_ROTATION, (Object)angle);
    }

    public void setLeftArmRotation(class_2379 angle) {
        this.leftArmRotation = angle;
        this.field_6011.method_12778(LEFT_ARM_ROTATION, (Object)angle);
    }

    public void setRightArmRotation(class_2379 angle) {
        this.rightArmRotation = angle;
        this.field_6011.method_12778(RIGHT_ARM_ROTATION, (Object)angle);
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1799 getItem() {
        return FowlPlayItems.SCARECROW.get().method_7854();
    }

    public class_2394 getParticle() {
        return new class_2388(class_2398.field_11217, class_2246.field_10359.method_9564());
    }

    public class_3414 getPlaceSound() {
        return class_3417.field_14718;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_14607, class_3417.field_14607);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14808;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15215;
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.getItem();
    }
}

