/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.SpecialPlantable;
import org.jetbrains.annotations.Nullable;

public class CropFullBlock
extends BushBlock
implements BonemealableBlock,
SpecialPlantable {
    public final Block stemBlock;
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<CropFullBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(CropFullBlock::getStemBlock), (App)CropFullBlock.propertiesCodec()).apply((Applicative)instance, CropFullBlock::new));

    public CropFullBlock(Block stemBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.stemBlock = stemBlock;
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    protected VoxelShape getCollisionShape(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        boolean isPlayer = context instanceof EntityCollisionContext && ((entityCollisionContext = (EntityCollisionContext)context).getEntity() instanceof LivingEntity || entityCollisionContext.getEntity() instanceof VehicleEntity || entityCollisionContext.getEntity() instanceof ItemEntity || entityCollisionContext.getEntity() instanceof ExperienceOrb);
        return isPlayer ? Shapes.block() : Shapes.empty();
    }

    public Block getStemBlock() {
        return this.stemBlock;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos blockPos, BlockState state) {
        return !world.getBlockState(blockPos.above()).is(this.stemBlock);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos blockPos, BlockState state) {
        return true;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter world, BlockPos blockPos) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos blockPos, BlockState state) {
        BlockPos above = blockPos.above();
        BlockPos below = blockPos.below();
        if (this.stemBlock != null && world.getBlockState(above).isAir()) {
            world.setBlock(above, this.stemBlock.defaultBlockState(), 2);
        }
        if (world.isStateAtPosition(below, BlockBehaviour.BlockStateBase::isAir) && this.shouldGrowRoots()) {
            world.setBlock(below, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState p_51034_, LevelAccessor world, BlockPos blockPos, BlockPos p_51037_) {
        return state;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
    }

    public boolean shouldGrowRoots() {
        return true;
    }

    public boolean canPlacePlantAtPosition(ItemStack itemStack, LevelReader level, BlockPos pos, @Nullable Direction direction) {
        return false;
    }

    public void spawnPlantAtPosition(ItemStack itemStack, LevelAccessor level, BlockPos pos, @Nullable Direction direction) {
    }
}

