/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.overweightfarming.blocks.CropFullBlock;

public class CropStemBlock
extends BushBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final MapCodec<CropStemBlock> CODEC = CropStemBlock.simpleCodec(CropStemBlock::new);

    public CropStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos blockPos) {
        Direction direction = this.getFacingDirection();
        BlockPos blockpos = blockPos.relative(direction.getOpposite());
        return world.getBlockState(blockpos).getBlock() instanceof CropFullBlock;
    }

    public Direction getFacingDirection() {
        return Direction.UP;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos blockPos, CollisionContext context) {
        return SHAPE;
    }
}

