/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.overweightfarming.blocks.CropFullBlock;
import net.orcinus.overweightfarming.blocks.blockentities.OverweightAppleBlockEntity;
import net.orcinus.overweightfarming.entities.OverweightAppleFallingBlockEntity;
import net.orcinus.overweightfarming.init.OFBlockEntityTypes;
import net.orcinus.overweightfarming.init.OFBlocks;
import org.jetbrains.annotations.Nullable;

public class OverweightAppleBlock
extends CropFullBlock
implements Fallable,
EntityBlock {
    private final boolean isGolden;

    public OverweightAppleBlock(boolean isGolden, Block stemBlock, BlockBehaviour.Properties properties) {
        super(stemBlock, properties);
        this.isGolden = isGolden;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState p_53236_, boolean p_53237_) {
        world.scheduleTick(pos, (Block)this, 2);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState p_51034_, LevelAccessor world, BlockPos blockPos, BlockPos p_51037_) {
        world.scheduleTick(blockPos, (Block)this, 2);
        return super.updateShape(state, direction, p_51034_, world, blockPos, p_51037_);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource p_221127_) {
        BlockState aboveState = world.getBlockState(pos.above());
        BlockState belowState = world.getBlockState(pos.below());
        if (!(aboveState.is(BlockTags.LEAVES) || aboveState.is(BlockTags.LOGS) || aboveState.is((Block)OFBlocks.OVERWEIGHT_APPLE_STEM.get()) || aboveState.is((Block)OFBlocks.OVERWEIGHT_GOLDEN_APPLE_STEM.get()) || !OverweightAppleBlock.isFree(belowState) || pos.getY() < world.getMinBuildHeight())) {
            this.spawnFallingBlock(state, (Level)world, pos);
        }
    }

    public void spawnFallingBlock(BlockState state, Level world, BlockPos pos) {
        OverweightAppleFallingBlockEntity fallingblockentity = new OverweightAppleFallingBlockEntity(this.isGolden, world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : state);
        world.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
        world.addFreshEntity((Entity)fallingblockentity);
    }

    public static boolean isFree(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.liquid() || state.canBeReplaced();
    }

    @Override
    public boolean shouldGrowRoots() {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OverweightAppleBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return !world.isClientSide ? OverweightAppleBlock.createTickerHelper(type, (BlockEntityType)OFBlockEntityTypes.OVERWEIGHT_APPLE.get(), OverweightAppleBlockEntity::tick) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> ticker) {
        return p_152134_ == p_152133_ ? ticker : null;
    }
}

