/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.data;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.orcinus.overweightfarming.blocks.CropStemBlock;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.init.OFItemTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OFBlockLootTables
extends BlockLootSubProvider {
    public OFBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.VANILLA_SET, provider);
    }

    protected void generate() {
        this.add((Block)OFBlocks.ALLIUM_BUSH.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf((Block)OFBlocks.HALF_SEEDED_PEELED_MELON.get());
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_APPLE.get(), Items.APPLE);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_BAKED_POTATO.get(), Items.BAKED_POTATO);
        this.simpleOverweightSeededCropDrop((Block)OFBlocks.OVERWEIGHT_BEETROOT.get(), Items.BEETROOT, Items.BEETROOT_SEEDS);
        this.simpleOverweightSeededCropDrop((Block)OFBlocks.OVERWEIGHT_CABBAGE.get(), Objects.requireNonNull(this.getCompatItem("farmersdelight", "cabbage")), Objects.requireNonNull(this.getCompatItem("farmersdelight", "cabbage_seeds")));
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_CARROT.get(), Items.CARROT);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_COCOA.get(), Items.COCOA_BEANS);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_GINGER.get(), this.getCompatItem("snowyspirit", "ginger"));
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_GOLDEN_APPLE.get(), Items.GOLDEN_APPLE);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_KIWI.get(), this.getCompatItem("hedgehog", "kiwi"));
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_NETHER_WART.get(), Items.NETHER_WART);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_ONION.get(), this.getCompatItem("farmersdelight", "onion"));
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_POISONOUS_POTATO.get(), Items.POISONOUS_POTATO);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_POTATO.get(), Items.POTATO);
        this.simpleOverweightCropDrop((Block)OFBlocks.OVERWEIGHT_SLICED_KIWI.get(), this.getCompatItem("hedgehog", "kiwi"));
        this.simpleOverweightSeededCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_BEETROOT.get(), Items.BEETROOT, Items.BEETROOT_SEEDS);
        this.simpleOverweightCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_CARROT.get(), Items.CARROT);
        this.simpleOverweightCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_COCOA.get(), Items.COCOA_BEANS);
        this.simpleOverweightCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_GINGER.get(), this.getCompatItem("snowyspirit", "ginger"));
        this.simpleOverweightCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_KIWI.get(), this.getCompatItem("hedgehog", "kiwi"));
        this.simpleOverweightCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_ONION.get(), this.getCompatItem("farmersdelight", "onion"));
        this.simpleOverweightCropDrop((Block)OFBlocks.PEELED_OVERWEIGHT_POTATO.get(), Items.POTATO);
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_BEETROOT.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_CARROT.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_POTATO.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_COCOA.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_APPLE.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_GOLDEN_APPLE.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_ONION.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_CABBAGE.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_GINGER.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_KIWI.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_POISONOUS_POTATO.get());
        this.dropPottedContents((Block)OFBlocks.POTTED_OVERWEIGHT_NETHER_WART.get());
        this.dropSelf((Block)OFBlocks.SEEDED_PEELED_MELON.get());
        this.dropSelf((Block)OFBlocks.SEEDLESS_PEELED_MELON.get());
        this.dropSelf((Block)OFBlocks.VEGETABLE_COMPOST.get());
        this.dropSelf((Block)OFBlocks.WAXED_HALF_SEEDED_PEELED_MELON.get());
        this.dropSelf((Block)OFBlocks.WAXED_SEEDED_PEELED_MELON.get());
        this.dropSelf((Block)OFBlocks.WAXED_SEEDLESS_PEELED_MELON.get());
    }

    @Nullable
    private Item getCompatItem(String modId, String item) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)item));
    }

    private void simpleOverweightSeededCropDrop(@NotNull Block block, Item item, Item seed) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)6.0f, (float)20.0f))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(OFItemTags.OVERWEIGHT_HARVESTABLES))), LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())})}))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)seed).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(OFItemTags.OVERWEIGHT_HARVESTABLES))))));
    }

    private void simpleOverweightCropDrop(@NotNull Block block, Item item) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)6.0f, (float)20.0f))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(OFItemTags.OVERWEIGHT_HARVESTABLES))), LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())})}))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return OFBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> !(block instanceof CropStemBlock)).collect(Collectors.toList());
    }
}

