/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.events;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.init.OFItems;
import net.orcinus.overweightfarming.util.OverweightGrowthManager;

@EventBusSubscriber(modid="overweight_farming")
public class MiscEvents {
    public static final Supplier<BiMap<Block, Block>> WAXABLES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)OFBlocks.SEEDED_PEELED_MELON.get()), (Object)((Block)OFBlocks.WAXED_SEEDED_PEELED_MELON.get())).put((Object)((Block)OFBlocks.HALF_SEEDED_PEELED_MELON.get()), (Object)((Block)OFBlocks.WAXED_HALF_SEEDED_PEELED_MELON.get())).put((Object)((Block)OFBlocks.SEEDLESS_PEELED_MELON.get()), (Object)((Block)OFBlocks.WAXED_SEEDLESS_PEELED_MELON.get())).build());
    public static final Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAXABLES.get().inverse());
    public static final Supplier<BiMap<Block, Block>> PEELABLES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)OFBlocks.OVERWEIGHT_BEETROOT.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_BEETROOT.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_CARROT.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_CARROT.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_POTATO.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_POTATO.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_ONION.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_ONION.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_KIWI.get()), (Object)((Block)OFBlocks.OVERWEIGHT_SLICED_KIWI.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_SLICED_KIWI.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_KIWI.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_GINGER.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_GINGER.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_COCOA.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_COCOA.get())).put((Object)Blocks.MELON, (Object)((Block)OFBlocks.SEEDED_PEELED_MELON.get())).build());
    public static final Supplier<BiMap<Block, Block>> UNPEELABLES = Suppliers.memoize(() -> PEELABLES.get().inverse());

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer serverPlayer;
        ItemStack stack = event.getItemStack();
        Level world = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState state = world.getBlockState(blockPos);
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (stack.getItem() instanceof AxeItem) {
            for (Block block : WAX_OFF_BY_BLOCK.get().keySet()) {
                if (!state.is(block)) continue;
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockPos, stack);
                }
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                world.playSound(null, blockPos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.setBlockAndUpdate(blockPos, ((Block)WAX_OFF_BY_BLOCK.get().get((Object)block)).defaultBlockState());
                world.levelEvent(player, 3004, blockPos, 0);
                player.swing(hand);
            }
            for (Block block : PEELABLES.get().keySet()) {
                if (!state.is(block)) continue;
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockPos, stack);
                }
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                world.playSound(null, blockPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                Block.popResource((Level)world, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)OFItems.VEGETABLE_PEELS.get()));
                world.setBlockAndUpdate(blockPos, ((Block)PEELABLES.get().get((Object)block)).defaultBlockState());
                player.swing(hand);
            }
        }
        if (stack.getItem() == Items.HONEYCOMB) {
            for (Block block : WAXABLES.get().keySet()) {
                if (!state.is(block)) continue;
                event.setCanceled(true);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockPos, stack);
                }
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                world.playSound(null, blockPos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.setBlockAndUpdate(blockPos, ((Block)WAXABLES.get().get((Object)block)).defaultBlockState());
                world.levelEvent(player, 3003, blockPos, 0);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
            }
        }
        if (stack.getItem() == OFItems.VEGETABLE_PEELS.get()) {
            for (Block block : UNPEELABLES.get().keySet()) {
                if (!state.is(block)) continue;
                event.setCanceled(true);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockPos, stack);
                }
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                world.playSound(null, blockPos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                BlockState blockState = ((Block)UNPEELABLES.get().get((Object)block)).defaultBlockState();
                world.setBlockAndUpdate(blockPos, blockState);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)world.isClientSide));
            }
        }
    }

    @SubscribeEvent
    public static void onCropsGrow(CropGrowEvent.Pre event) {
        LevelAccessor level = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState state = event.getState();
        RandomSource random = level.getRandom();
        OverweightGrowthManager manager = new OverweightGrowthManager(random);
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (Block cropBlock : manager.getOverweightMap().keySet()) {
                float chance;
                boolean flag3;
                if (!state.is(cropBlock)) continue;
                boolean flag = state.hasProperty((Property)CropBlock.AGE) && (Integer)state.getValue((Property)CropBlock.AGE) < 7 && (Integer)state.getValue((Property)CropBlock.AGE) == 3;
                boolean flag1 = state.hasProperty((Property)CocoaBlock.AGE) && (Integer)state.getValue((Property)CocoaBlock.AGE) == 1;
                boolean flag2 = (state.getBlock() instanceof BeetrootBlock || state.getBlock() instanceof NetherWartBlock) && state.hasProperty((Property)BlockStateProperties.AGE_3) && (Integer)state.getValue((Property)BlockStateProperties.AGE_3) < 3 && (Integer)state.getValue((Property)BlockStateProperties.AGE_3) > 1;
                boolean bl = flag3 = ModList.get().isLoaded("hedgehog") && state.getBlock() == BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"hedgehog", (String)"kiwi_vines")) && (Boolean)state.getValue((Property)BlockStateProperties.BERRIES) != false;
                if (!flag && !flag1 && !flag2 && !flag3) continue;
                float f = chance = world.isNight() && world.getMoonPhase() == 0 ? 0.0010538863f : 3.4290552E-4f;
                if (!(random.nextFloat() < chance)) continue;
                event.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
                manager.growOverweightCrops(world, blockPos, state, random);
            }
        }
    }
}

