/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.orcinus.overweightfarming.init.OFItems;
import net.orcinus.overweightfarming.util.OFItemsForEmeralds;
import net.orcinus.overweightfarming.util.OverweightGrowthManager;

@EventBusSubscriber(modid="overweight_farming")
public class TickEvents {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.getItemInHand(hand);
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (stack.getItem() == OFItems.VEGETABLE_PEELS.get()) {
                int i = pig.getAge();
                if (!pig.level().isClientSide && i == 0 && pig.canFallInLove()) {
                    event.setCanceled(true);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    pig.setInLove(player);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                if (pig.isBaby()) {
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    pig.ageUp((int)((float)(-i / 20) * 0.1f), true);
                    player.swing(hand);
                }
                if (pig.level().isClientSide) {
                    event.setCancellationResult(InteractionResult.CONSUME);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onVillagerTradesInit(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        if (profession == VillagerProfession.FARMER) {
            OFItemsForEmeralds hatTrade = new OFItemsForEmeralds((Item)OFItems.STRAW_HAT.get(), 20, 1, 4);
            Int2ObjectMap map = event.getTrades();
            List list = (List)event.getTrades().get(5);
            list.add(hatTrade);
            map.put(5, (Object)list);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            pig.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)pig, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OFItems.VEGETABLE_PEELS.get()}), false));
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        Level world;
        AgeableMob mob = event.getChild();
        Mob mobA = event.getParentA();
        Mob mobB = event.getParentB();
        Player player = event.getCausedByPlayer();
        if (player != null && player.getItemBySlot(EquipmentSlot.HEAD).is((Item)OFItems.STRAW_HAT.get()) && mob instanceof Animal && (world = mob.level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            if (mobA instanceof Animal) {
                Animal animalParentA = (Animal)mobA;
                if (mobB instanceof Animal) {
                    Animal animalParentB = (Animal)mobB;
                    RandomSource random = world.getRandom();
                    int tries = 0;
                    if (random.nextInt(3) == 0) {
                        ++tries;
                        if (random.nextInt(12) == 0) {
                            ++tries;
                        }
                    }
                    for (int i = 0; i < tries; ++i) {
                        AgeableMob newChild = animalParentA.getBreedOffspring(level, (AgeableMob)animalParentB);
                        if (newChild == null) continue;
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            serverPlayer.awardStat(Stats.ANIMALS_BRED);
                            CriteriaTriggers.BRED_ANIMALS.trigger(serverPlayer, animalParentA, animalParentB, newChild);
                        }
                        newChild.setBaby(true);
                        newChild.moveTo(animalParentA.getX(), animalParentA.getY(), animalParentA.getZ(), 0.0f, 0.0f);
                        level.addFreshEntityWithPassengers((Entity)newChild);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(EntityTickEvent.Pre event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        Level world = entity.level();
        if (!world.isClientSide() && entity instanceof LivingEntity && (living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.HEAD).is((Item)OFItems.STRAW_HAT.get())) {
            int radius = 40;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        boolean asda;
                        boolean hedgehogFlag;
                        BlockPos entityPosition = entity.blockPosition();
                        BlockPos cropPos = new BlockPos(entityPosition.getX() + x, entityPosition.getY() + y, entityPosition.getZ() + z);
                        BlockState state = world.getBlockState(cropPos);
                        String hedgehogModid = "hedgehog";
                        Block kiwiVines = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)hedgehogModid, (String)"kiwi_vines"));
                        boolean bl = hedgehogFlag = ModList.get().isLoaded(hedgehogModid) && state.is(Objects.requireNonNull(kiwiVines));
                        if (!state.is(BlockTags.CROPS) && !hedgehogFlag && !(state.getBlock() instanceof NetherWartBlock)) continue;
                        Block block = state.getBlock();
                        float v = world.getRandom().nextFloat();
                        boolean flag = (double)v < 1.6540289E-4 && world.getRandom().nextBoolean();
                        boolean validForOverweight = false;
                        if (!(world instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)world;
                        if (!flag) continue;
                        if (state.is(kiwiVines) && state.hasProperty((Property)BlockStateProperties.BERRIES) && ((Boolean)state.getValue((Property)BlockStateProperties.BERRIES)).booleanValue()) {
                            validForOverweight = true;
                        }
                        if (state.hasProperty((Property)CropBlock.AGE)) {
                            int age;
                            if (block instanceof CropBlock) {
                                CropBlock crop = (CropBlock)block;
                                int age2 = (Integer)state.getValue((Property)CropBlock.AGE);
                                if (age2 < crop.getMaxAge()) {
                                    crop.growCrops((Level)serverLevel, cropPos, state);
                                }
                                if (age2 == crop.getMaxAge()) {
                                    validForOverweight = true;
                                }
                            } else if (block instanceof StemBlock && (age = ((Integer)state.getValue((Property)StemBlock.AGE)).intValue()) < 7) {
                                serverLevel.setBlock(cropPos, (BlockState)state.setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                            }
                        }
                        if (asda = state.hasProperty((Property)BlockStateProperties.AGE_3)) {
                            if (block instanceof BeetrootBlock) {
                                BeetrootBlock beetrootBlock = (BeetrootBlock)block;
                                int age = (Integer)state.getValue((Property)BeetrootBlock.AGE);
                                if (age < beetrootBlock.getMaxAge()) {
                                    beetrootBlock.growCrops((Level)serverLevel, cropPos, state);
                                }
                                if (age == beetrootBlock.getMaxAge()) {
                                    validForOverweight = true;
                                }
                            }
                            if (block instanceof NetherWartBlock) {
                                int age = (Integer)state.getValue((Property)NetherWartBlock.AGE);
                                if (age < 3) {
                                    world.setBlock(cropPos, (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)NetherWartBlock.AGE) + 1)), 2);
                                }
                                if (age == 3) {
                                    validForOverweight = true;
                                }
                            }
                        }
                        OverweightGrowthManager manager = new OverweightGrowthManager(world.getRandom());
                        if (!validForOverweight) continue;
                        for (Block overgrowth : manager.getOverweightMap().keySet()) {
                            if (!state.is(overgrowth)) continue;
                            manager.growOverweightCrops(serverLevel, cropPos, state, serverLevel.getRandom());
                        }
                    }
                }
            }
        }
    }
}

