/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.datagen.assets;

import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class EnchantableLanguageProvider
extends LanguageProvider {
    public EnchantableLanguageProvider(PackOutput packOutput) {
        super(packOutput, "enchantableblocks", "en_us");
    }

    protected void addTranslations() {
        this.addBlock((Supplier)ModRegistry.ENCHANTED_FURNACE, "Furnace");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_BLAST_FURNACE, "Blast Furnace");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_SMOKER, "Smoker");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_BEACON, "Beacon");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_CAMPFIRE, "Campfire");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_SOUL_CAMPFIRE, "Soul Campfire");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_MAGMA_BLOCK, "Magma Block");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_DISPENSER, "Dispenser");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_RESPAWN_ANCHOR, "Respawn Anchor");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_HOPPER, "Hopper");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_ENCHANTING_TABLE, "Enchanting Table");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_CONDUIT, "Conduit");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_CRAFTING_TABLE, "Crafting Table");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_BEEHIVE, "Beehive");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_CHEST, "Chest");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_TRAPPED_CHEST, "Trapped Chest");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_WHITE_BED, "White Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_ORANGE_BED, "Orange Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_MAGENTA_BED, "Magenta Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_LIGHT_BLUE_BED, "Light Blue Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_YELLOW_BED, "Yellow Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_LIME_BED, "Lime Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_PINK_BED, "Pink Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_GRAY_BED, "Gray Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_LIGHT_GRAY_BED, "Light Gray Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_CYAN_BED, "Cyan Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_PURPLE_BED, "Purple Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_BLUE_BED, "Blue Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_BROWN_BED, "Brown Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_GREEN_BED, "Green Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_RED_BED, "Red Bed");
        this.addBlock((Supplier)ModRegistry.ENCHANTED_BLACK_BED, "Black Bed");
        this.addEnchantment(ModEnchantments.SPEED, "Speed");
        this.addEnchantmentDescription(ModEnchantments.SPEED, "Increases the speed at which functions are performed");
        this.addEnchantment(ModEnchantments.BLOCK_EFFICIENCY, "Block Efficiency");
        this.addEnchantmentDescription(ModEnchantments.BLOCK_EFFICIENCY, "Increases the efficiency of the block");
        this.addEnchantment(ModEnchantments.YIELD, "Yield");
        this.addEnchantmentDescription(ModEnchantments.YIELD, "Adds a chance of increased results");
        this.addEnchantment(ModEnchantments.PRESERVATION, "Preservation");
        this.addEnchantmentDescription(ModEnchantments.PRESERVATION, "Preserves the resources used in the block");
        this.addEnchantment(ModEnchantments.SOLAR_RADIANCE, "Solar Radiance");
        this.addEnchantmentDescription(ModEnchantments.SOLAR_RADIANCE, "Harnesses the power of the sun");
        this.addEnchantment(ModEnchantments.EXPORTING, "Exporting");
        this.addEnchantmentDescription(ModEnchantments.EXPORTING, "Auto exports results from the block");
        this.addEnchantment(ModEnchantments.CONCEALED, "Concealed");
        this.addEnchantmentDescription(ModEnchantments.CONCEALED, "Conceals external visuals produced by the block");
        this.addEnchantment(ModEnchantments.GLINTLESS, "Glintless");
        this.addEnchantmentDescription(ModEnchantments.GLINTLESS, "Removes the enchantment glint from the block");
        this.addEnchantment(ModEnchantments.RANGED, "Ranged");
        this.addEnchantmentDescription(ModEnchantments.RANGED, "Increases the range of the block");
        this.addEnchantment(ModEnchantments.INTENTIONAL_GAME_DESIGN, "Intentional Game Design");
        this.addEnchantmentDescription(ModEnchantments.INTENTIONAL_GAME_DESIGN, "The functionality of this enchantment is intentional");
        this.addEnchantment(ModEnchantments.BOILING, "Boiling");
        this.addEnchantmentDescription(ModEnchantments.BOILING, "Increases the temperature of the block");
        this.addEnchantment(ModEnchantments.WELL_RESTED, "Well Rested");
        this.addEnchantmentDescription(ModEnchantments.WELL_RESTED, "Gives the player a reward for sleeping in the bed");
        this.addEnchantment(ModEnchantments.STORING, "Storing");
        this.addEnchantmentDescription(ModEnchantments.STORING, "Increases the storage capacity of the block");
        this.addEnchantment(ModEnchantments.DAMAGE, "Damage");
        this.addEnchantmentDescription(ModEnchantments.DAMAGE, "Increases the damage dealt by the block");
        this.addEnchantment(ModEnchantments.BLOCK_PROTECTION, "Block Protection");
        this.addEnchantmentDescription(ModEnchantments.BLOCK_PROTECTION, "Protects the block from external damage");
        this.add("config.jade.plugin_enchantableblocks.enchantments", "Enchantments");
    }

    private void addEnchantment(ResourceKey<Enchantment> key, String name) {
        ResourceLocation location = key.location();
        this.add("enchantment." + location.getNamespace() + "." + location.getPath(), name);
    }

    private void addEnchantmentDescription(ResourceKey<Enchantment> key, String description) {
        ResourceLocation location = key.location();
        this.add("enchantment." + location.getNamespace() + "." + location.getPath() + ".desc", description);
    }
}

